/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.scr.impl.inject.ComponentMethods;
import org.apache.felix.scr.impl.inject.LifecycleMethod;
import org.apache.felix.scr.impl.inject.MethodResult;
import org.apache.felix.scr.impl.inject.OpenStatus;
import org.apache.felix.scr.impl.inject.RefPair;
import org.apache.felix.scr.impl.inject.ReferenceMethod;
import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ComponentContainer;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.manager.EdgeInfo;
import org.apache.felix.scr.impl.metadata.DSVersion;
import org.apache.felix.scr.impl.metadata.TargetedPID;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentInstance;
import org.osgi.util.promise.Deferred;

public class SingleComponentManager<S>
extends AbstractComponentManager<S>
implements ServiceFactory<S> {
    private final AtomicInteger m_useCount = new AtomicInteger();
    private volatile ComponentContextImpl<S> m_componentContext;
    private Map<String, Object> m_configurationProperties;
    private Map<String, Object> m_factoryProperties;
    private Map<String, Object> m_properties;
    private Dictionary<String, Object> m_serviceProperties;

    public SingleComponentManager(ComponentContainer<S> container, ComponentMethods<S> componentMethods) {
        this(container, componentMethods, false);
    }

    public SingleComponentManager(ComponentContainer<S> container, ComponentMethods<S> componentMethods, boolean factoryInstance) {
        super(container, componentMethods, factoryInstance);
    }

    @Override
    void clear() {
        this.m_container.disposed(this);
        super.clear();
    }

    private boolean createComponent(ComponentContextImpl<S> componentContext) {
        if (!this.isStateLocked()) {
            throw new IllegalStateException("need write lock (createComponent)");
        }
        if (this.m_componentContext == null) {
            S tmpComponent = this.createImplementationObject(null, new SetImplementationObject<S>(){

                @Override
                public void presetComponentContext(ComponentContextImpl<S> componentContext) {
                    SingleComponentManager.this.m_componentContext = componentContext;
                }

                @Override
                public void resetImplementationObject(S implementationObject) {
                    SingleComponentManager.this.m_componentContext = null;
                }
            }, componentContext);
            if (tmpComponent == null) {
                return false;
            }
            this.getLogger().log(InternalLogger.Level.DEBUG, "Set implementation object for component", null);
            try {
                this.m_container.getActivator().missingServicePresent(this.getServiceReference());
            }
            catch (IllegalStateException ise) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void deleteComponent(int reason) {
        if (!this.isStateLocked()) {
            throw new IllegalStateException("need write lock (deleteComponent)");
        }
        if (this.m_componentContext != null) {
            this.m_useCount.set(0);
            this.disposeImplementationObject(this.m_componentContext, reason);
            this.m_componentContext = null;
            this.getLogger().log(InternalLogger.Level.DEBUG, "Unset and deconfigured implementation object for component in deleteComponent for reason {0}", null, REASONS[reason]);
            this.clearServiceProperties();
        }
    }

    void clearServiceProperties() {
        this.m_properties = null;
        this.m_serviceProperties = null;
    }

    public ComponentInstance<S> getComponentInstance() {
        return this.m_componentContext == null ? null : this.m_componentContext.getComponentInstance();
    }

    private S getInstance() {
        return this.m_componentContext == null ? null : (S)this.m_componentContext.getImplementationObject(true);
    }

    protected S createImplementationObject(Bundle usingBundle, SetImplementationObject<S> setter, ComponentContextImpl<S> componentContext) {
        Object implementationObject = null;
        Bundle bundle = this.getBundle();
        if (bundle == null) {
            this.getLogger().log(InternalLogger.Level.WARN, "Bundle shut down during instantiation of the implementation object", null);
            return null;
        }
        ArrayList openStatusList = new ArrayList();
        HashMap paramMap = this.getComponentMetadata().getNumberOfConstructorParameters() > 0 ? new HashMap() : null;
        boolean failed = false;
        for (DependencyManager<Object, ?> dependencyManager : this.getDependencyManagers()) {
            OpenStatus<Object, ?> openStatus = dependencyManager.open(componentContext, componentContext.getEdgeInfo(dependencyManager));
            if (openStatus == null) {
                this.getLogger().log(InternalLogger.Level.DEBUG, "Cannot create component instance due to failure to bind reference {0}", null, dependencyManager.getName());
                failed = true;
                break;
            }
            openStatusList.add(openStatus);
            if (dependencyManager.getReferenceMetadata().getParameterIndex() == null) continue;
            if (!dependencyManager.bindDependency(componentContext, ReferenceMethod.NOPReferenceMethod, openStatus)) {
                this.getLogger().log(InternalLogger.Level.DEBUG, "Cannot create component instance due to failure to bind reference {0}", null, dependencyManager.getName());
                failed = true;
                break;
            }
            paramMap.put(dependencyManager.getReferenceMetadata(), openStatus);
        }
        if (!failed) {
            try {
                implementationObject = this.getComponentMethods().getConstructor().newInstance(componentContext, paramMap);
            }
            catch (InstantiationException ie) {
                this.getLogger().log(InternalLogger.Level.ERROR, "Error during instantiation of the implementation object: " + ie.getMessage(), null);
                this.setFailureReason(ie);
                return null;
            }
            catch (Throwable t) {
                this.getLogger().log(InternalLogger.Level.ERROR, "Error during instantiation of the implementation object", t);
                this.setFailureReason(t);
                return null;
            }
            componentContext.setImplementationObject(implementationObject);
            setter.presetComponentContext(componentContext);
            Iterator iter = openStatusList.iterator();
            for (DependencyManager<Object, ?> dependencyManager : this.getDependencyManagers()) {
                OpenStatus openStatus;
                if (dependencyManager.bind(componentContext, openStatus = (OpenStatus)iter.next())) continue;
                this.getLogger().log(InternalLogger.Level.DEBUG, "Cannot create component instance due to failure to bind reference {0}", null, dependencyManager.getName());
                failed = true;
                break;
            }
        }
        if (failed) {
            int skipCount = this.getReversedDependencyManagers().size() - openStatusList.size();
            for (DependencyManager<Object, ?> dependencyManager : this.getReversedDependencyManagers()) {
                if (skipCount > 0) {
                    --skipCount;
                } else {
                    dependencyManager.close(componentContext, componentContext.getEdgeInfo(dependencyManager));
                }
                dependencyManager.deactivate();
            }
            setter.resetImplementationObject(implementationObject);
            return null;
        }
        MethodResult failedResult = new MethodResult(true, new HashMap<String, Object>());
        MethodResult methodResult = this.getComponentMethods().getActivateMethod().invoke(implementationObject, componentContext, 1, failedResult);
        if (methodResult == failedResult) {
            this.setFailureReason((Throwable)failedResult.getResult().get("exception"));
            for (DependencyManager<Object, ?> dependencyManager : this.getReversedDependencyManagers()) {
                dependencyManager.close(componentContext, componentContext.getEdgeInfo(dependencyManager));
            }
            if (implementationObject != null) {
                setter.resetImplementationObject(implementationObject);
            }
            return null;
        }
        componentContext.setImplementationAccessible(true);
        try {
            this.m_container.getActivator().leaveCreate(this.getServiceReference());
        }
        catch (IllegalStateException illegalStateException) {
            this.setFailureReason(illegalStateException);
            for (DependencyManager<Object, ?> dependencyManager : this.getReversedDependencyManagers()) {
                dependencyManager.close(componentContext, componentContext.getEdgeInfo(dependencyManager));
            }
            if (implementationObject != null) {
                setter.resetImplementationObject(implementationObject);
            }
            return null;
        }
        this.setServiceProperties(methodResult, null);
        return implementationObject;
    }

    protected void disposeImplementationObject(ComponentContextImpl<S> componentContext, int reason) {
        componentContext.setImplementationAccessible(false);
        S implementationObject = componentContext.getImplementationObject(false);
        if (implementationObject != null) {
            MethodResult result = this.getComponentMethods().getDeactivateMethod().invoke(implementationObject, componentContext, reason, null);
            if (result != null) {
                this.setServiceProperties(result, null);
            }
            for (DependencyManager<S, ?> md : this.getReversedDependencyManagers()) {
                md.close(componentContext, componentContext.getEdgeInfo(md));
            }
        }
        componentContext.cleanup();
    }

    @Override
    <T> void invokeBindMethod(DependencyManager<S, T> dependencyManager, RefPair<S, T> refPair, int trackingCount) {
        ComponentContextImpl<S> componentContext = this.m_componentContext;
        if (componentContext != null) {
            EdgeInfo info = componentContext.getEdgeInfo(dependencyManager);
            dependencyManager.invokeBindMethod(componentContext, refPair, trackingCount, info);
        }
    }

    @Override
    <T> boolean invokeUpdatedMethod(DependencyManager<S, T> dependencyManager, RefPair<S, T> refPair, int trackingCount) {
        ComponentContextImpl<S> componentContext = this.m_componentContext;
        if (componentContext != null) {
            EdgeInfo info = componentContext.getEdgeInfo(dependencyManager);
            return dependencyManager.invokeUpdatedMethod(componentContext, refPair, trackingCount, info);
        }
        return false;
    }

    @Override
    <T> void invokeUnbindMethod(DependencyManager<S, T> dependencyManager, RefPair<S, T> oldRefPair, int trackingCount) {
        ComponentContextImpl<S> componentContext = this.m_componentContext;
        if (componentContext != null) {
            EdgeInfo info = componentContext.getEdgeInfo(dependencyManager);
            dependencyManager.invokeUnbindMethod(componentContext, oldRefPair, trackingCount, info);
        }
    }

    protected void setFactoryProperties(Dictionary<String, ?> dictionary) {
        this.m_factoryProperties = SingleComponentManager.copyToMap(dictionary, true);
    }

    @Override
    void registerComponentId() {
        super.registerComponentId();
        this.m_properties = null;
    }

    @Override
    void unregisterComponentId() {
        super.unregisterComponentId();
        this.m_properties = null;
    }

    @Override
    public Map<String, Object> getProperties() {
        if (this.m_properties == null) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            if (this.m_configurationProperties != null) {
                props.putAll(this.m_configurationProperties);
            }
            if (this.m_factoryProperties != null) {
                props.putAll(this.m_factoryProperties);
                if (this.getComponentMetadata().getDSVersion().isDS13() && this.m_factoryProperties.containsKey("service.pid")) {
                    ArrayList<String> servicePids = new ArrayList<String>();
                    Object configPropServicePids = this.m_configurationProperties.get("service.pid");
                    if (configPropServicePids instanceof List) {
                        servicePids.addAll((List)configPropServicePids);
                    } else {
                        servicePids.add(configPropServicePids.toString());
                    }
                    if (this.m_factoryProperties.get("service.pid") instanceof String) {
                        servicePids.add((String)this.m_factoryProperties.get("service.pid"));
                    }
                    if (servicePids.size() == 1) {
                        props.put("service.pid", servicePids.get(0));
                    } else {
                        props.put("service.pid", servicePids);
                    }
                }
            }
            props.put("component.name", this.getComponentMetadata().getName());
            props.put("component.id", this.getId());
            this.m_properties = props;
        }
        return this.m_properties;
    }

    @Override
    public void setServiceProperties(Dictionary<String, ?> serviceProperties) {
        if (serviceProperties == null || serviceProperties.isEmpty()) {
            this.m_serviceProperties = null;
        } else {
            this.m_serviceProperties = SingleComponentManager.copyToDictionary(serviceProperties, false);
            this.m_serviceProperties.put("component.name", this.getComponentMetadata().getName());
            this.m_serviceProperties.put("component.id", this.getId());
        }
        this.updateServiceRegistration();
    }

    @Override
    void postRegister() {
        if (this.m_serviceProperties != null) {
            this.updateServiceRegistration();
        }
    }

    @Override
    void preDeregister() {
        if (this.m_componentContext != null) {
            this.m_componentContext.unsetServiceRegistration();
        }
    }

    @Override
    public Dictionary<String, Object> getServiceProperties() {
        if (this.m_serviceProperties != null) {
            return this.m_serviceProperties;
        }
        return super.getServiceProperties();
    }

    final ServiceReference<S> getServiceReference() {
        ServiceRegistration<S> reg = this.getServiceRegistration();
        if (reg != null) {
            return reg.getReference();
        }
        return null;
    }

    @Override
    protected ServiceRegistration<S> getServiceRegistration() {
        if (this.getComponentMetadata().getDSVersion() == DSVersion.DS12Felix) {
            return this.m_componentContext != null ? this.m_componentContext.getServiceRegistration() : null;
        }
        return super.getServiceRegistration();
    }

    private void updateServiceRegistration() {
        block7: {
            ServiceRegistration<S> sr = this.getServiceRegistration();
            if (sr != null) {
                try {
                    Dictionary<String, Object> regProps = this.getServiceProperties();
                    if (!this.servicePropertiesMatches(sr, regProps)) {
                        sr.setProperties(regProps);
                        break block7;
                    }
                    this.getLogger().log(InternalLogger.Level.DEBUG, "Not updating service registration, no change in properties", null);
                }
                catch (IllegalStateException regProps) {
                }
                catch (IllegalArgumentException iae) {
                    this.getLogger().log(InternalLogger.Level.ERROR, "Unexpected configuration property problem when updating service registration", iae);
                }
                catch (Throwable t) {
                    this.getLogger().log(InternalLogger.Level.ERROR, "Unexpected problem when updating service registration", t);
                }
            } else {
                this.getLogger().log(InternalLogger.Level.DEBUG, "No service registration to update", null);
            }
        }
    }

    @Override
    public void reconfigure(Map<String, Object> configuration, boolean configurationDeleted, TargetedPID factoryPid) {
        this.m_configurationProperties = configuration;
        this.reconfigure(configurationDeleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconfigure(boolean configurationDeleted) {
        block14: {
            Deferred<Void> enableLatch = this.enableLatchWait();
            try {
                this.m_properties = null;
                if (!this.getState().isEnabled()) {
                    this.getLogger().log(InternalLogger.Level.DEBUG, "Component can not be activated since it is in state {0}", null, new Object[]{this.getState()});
                    return;
                }
                this.obtainActivationWriteLock();
                try {
                    if (!this.getState().isSatisfied() && !this.getComponentMetadata().isConfigurationIgnored()) {
                        this.getLogger().log(InternalLogger.Level.DEBUG, "Attempting to activate unsatisfied component", null);
                        this.updateTargets(this.getProperties());
                        this.releaseActivationWriteeLock();
                        this.activateInternal();
                        return;
                    }
                    if (this.modify(configurationDeleted)) break block14;
                    this.getLogger().log(InternalLogger.Level.DEBUG, "Deactivating and Activating to reconfigure from configuration", null);
                    int reason = configurationDeleted ? 4 : 3;
                    this.releaseActivationWriteeLock();
                    boolean dispose = this.m_factoryInstance;
                    this.deactivateInternal(reason, dispose, dispose);
                    if (dispose) break block14;
                    this.obtainActivationWriteLock();
                    try {
                        this.updateTargets(this.getProperties());
                    }
                    finally {
                        this.releaseActivationWriteeLock();
                    }
                    this.activateInternal();
                }
                finally {
                    this.releaseActivationWriteeLock();
                }
            }
            finally {
                enableLatch.resolve(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean modify(boolean configurationDeleted) {
        if (configurationDeleted && !this.getComponentMetadata().isDeleteCallsModify()) {
            return false;
        }
        if (this.getComponentMetadata().getModified() == null) {
            this.getLogger().log(InternalLogger.Level.DEBUG, "No modified method, cannot update dynamically", null);
            return false;
        }
        Map<String, Object> props = this.getProperties();
        for (DependencyManager dm : this.getDependencyManagers()) {
            if (dm.canUpdateDynamically(props)) continue;
            this.getLogger().log(InternalLogger.Level.DEBUG, "Cannot dynamically update the configuration due to dependency changes induced on dependency {0}", null, dm.getName());
            return false;
        }
        this.obtainStateLock();
        try {
            MethodResult result = this.invokeModifiedMethod();
            this.updateTargets(props);
            if (result == null) {
                this.getLogger().log(InternalLogger.Level.ERROR, "Declared modify method ''{0}'' cannot be found, configuring by reactivation", null, this.getComponentMetadata().getModified());
                boolean bl = false;
                return bl;
            }
            if (!this.verifyDependencyManagers()) {
                this.getLogger().log(InternalLogger.Level.DEBUG, "Updating the service references caused at least one reference to become unsatisfied, deactivating component", null);
                boolean bl = false;
                return bl;
            }
            if (result.hasResult()) {
                this.setServiceProperties(result, null);
            } else {
                this.updateServiceRegistration();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseStateLock();
        }
    }

    protected MethodResult invokeModifiedMethod() {
        LifecycleMethod modifiedMethod = this.getComponentMethods().getModifiedMethod();
        if (this.getInstance() != null) {
            return modifiedMethod.invoke(this.getInstance(), this.m_componentContext, -1, MethodResult.VOID);
        }
        return MethodResult.VOID;
    }

    private boolean servicePropertiesMatches(ServiceRegistration<S> reg, Dictionary<String, Object> props) {
        Hashtable<String, Object> regProps = new Hashtable<String, Object>();
        String[] keys = reg.getReference().getPropertyKeys();
        for (int i = 0; keys != null && i < keys.length; ++i) {
            if (keys[i].equals("objectClass") || keys[i].equals("service.id")) continue;
            ((Dictionary)regProps).put(keys[i], reg.getReference().getProperty(keys[i]));
        }
        return ((Object)regProps).equals(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public S getService(Bundle bundle, ServiceRegistration<S> serviceRegistration) {
        ServiceReference<S> ref = null;
        try {
            ref = serviceRegistration.getReference();
        }
        catch (IllegalStateException ise) {
            return null;
        }
        if (this.m_container.getActivator().enterCreate(ref)) {
            return null;
        }
        try {
            S s;
            block18: {
                boolean decrement;
                block16: {
                    S s2;
                    block17: {
                        this.obtainStateLock();
                        try {
                            this.m_useCount.incrementAndGet();
                        }
                        finally {
                            this.releaseStateLock();
                        }
                        decrement = true;
                        try {
                            boolean success = this.getServiceInternal(serviceRegistration);
                            ComponentContextImpl<S> componentContext = this.m_componentContext;
                            if (!success || componentContext == null) break block16;
                            decrement = false;
                            s2 = componentContext.getImplementationObject(true);
                            if (!decrement) break block17;
                            this.ungetService(bundle, serviceRegistration, null);
                        }
                        catch (Throwable throwable) {
                            if (decrement) {
                                this.ungetService(bundle, serviceRegistration, null);
                            }
                            throw throwable;
                        }
                    }
                    return s2;
                }
                s = null;
                if (!decrement) break block18;
                this.ungetService(bundle, serviceRegistration, null);
            }
            return s;
        }
        finally {
            this.m_container.getActivator().leaveCreate(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean getServiceInternal(ServiceRegistration<S> serviceRegistration) {
        boolean success = true;
        if (this.m_componentContext == null) {
            ComponentContextImpl<S> componentContext = new ComponentContextImpl<S>(this, this.getBundle(), serviceRegistration);
            if (!this.collectDependencies(componentContext)) {
                this.getLogger().log(InternalLogger.Level.INFO, "Could not obtain all required dependencies, getService returning null", null);
                return false;
            }
            this.getLogger().log(InternalLogger.Level.DEBUG, "getService (single component manager) dependencies collected.", null);
            this.obtainStateLock();
            try {
                if (this.m_componentContext == null) {
                    AbstractComponentManager.State previousState = this.getState();
                    S result = this.getService(componentContext);
                    if (result == null) {
                        success = false;
                    } else {
                        this.setState(previousState, AbstractComponentManager.State.active);
                    }
                }
            }
            finally {
                this.releaseStateLock();
            }
        }
        return success;
    }

    private S getService(ComponentContextImpl<S> componentContext) {
        if (!this.getState().isEnabled()) {
            return null;
        }
        if (this.createComponent(componentContext)) {
            return this.getInstance();
        }
        this.getLogger().log(InternalLogger.Level.DEBUG, "Failed creating the component instance; see log for reason", null);
        try {
            this.deleteComponent(0);
        }
        catch (Throwable t) {
            this.getLogger().log(InternalLogger.Level.DEBUG, "Cannot delete incomplete component instance. Ignoring.", t);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ungetService(Bundle bundle, ServiceRegistration<S> serviceRegistration, S o) {
        this.obtainStateLock();
        try {
            if (!(this.m_useCount.decrementAndGet() != 0 || this.isImmediate() || this.getComponentMetadata().isFactory() || this.keepInstances())) {
                AbstractComponentManager.State previousState = this.getState();
                this.deleteComponent(0);
                this.setState(previousState, AbstractComponentManager.State.satisfied);
            }
        }
        finally {
            this.releaseStateLock();
        }
    }

    private boolean keepInstances() {
        return this.getComponentMetadata().isDelayedKeepInstances();
    }

    @Override
    public void getComponentManagers(List<AbstractComponentManager<S>> cms) {
        cms.add(this);
    }

    protected static interface SetImplementationObject<S> {
        public void presetComponentContext(ComponentContextImpl<S> var1);

        public void resetImplementationObject(S var1);
    }
}

