/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.logger.ScrLogger;
import org.apache.felix.scr.impl.manager.ComponentActivator;
import org.apache.felix.scr.impl.manager.ComponentHolder;
import org.apache.felix.scr.impl.metadata.TargetedPID;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.cm.ConfigurationPermission;
import org.osgi.service.cm.ManagedService;

public abstract class RegionConfigurationSupport {
    private final ScrLogger logger;
    private final ServiceReference<ConfigurationAdmin> caReference;
    private final BundleContext caBundleContext;
    private final Long bundleId;
    private final AtomicInteger referenceCount = new AtomicInteger(1);
    private volatile ServiceRegistration<ConfigurationListener> m_registration;

    public RegionConfigurationSupport(ScrLogger logger, ServiceReference<ConfigurationAdmin> reference, Bundle bundle) {
        this.logger = logger;
        this.caReference = reference;
        this.bundleId = bundle.getBundleId();
        this.caBundleContext = bundle.getBundleContext();
    }

    public void start() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Declarative Services Configuration Support Listener");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ConfigurationListener serviceDelegator = System.getSecurityManager() != null ? new ConfigurationListener(){

            @Override
            public void configurationEvent(final ConfigurationEvent event) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Void run() {
                        RegionConfigurationSupport.this.configurationEvent(event);
                        return null;
                    }
                });
            }
        } : new ConfigurationListener(){

            @Override
            public void configurationEvent(ConfigurationEvent event) {
                RegionConfigurationSupport.this.configurationEvent(event);
            }
        };
        this.m_registration = this.caBundleContext.registerService(ConfigurationListener.class, serviceDelegator, props);
    }

    public Long getBundleId() {
        return this.bundleId;
    }

    public boolean reference() {
        if (this.referenceCount.get() == 0) {
            return false;
        }
        this.referenceCount.incrementAndGet();
        return true;
    }

    public boolean dereference() {
        if (this.referenceCount.decrementAndGet() == 0) {
            this.m_registration.unregister();
            this.m_registration = null;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean configureComponentHolder(ComponentHolder<?> holder) {
        block32: {
            if (holder.getComponentMetadata().isConfigurationIgnored() != false) return false;
            bundleContext = holder.getActivator().getBundleContext();
            if (bundleContext == null) {
                return false;
            }
            confPids = holder.getComponentMetadata().getConfigurationPid();
            ca = this.getConfigAdmin(bundleContext);
            if (ca == null) {
                return false;
            }
            var5_5 = confPids.iterator();
lbl11:
            // 2 sources

            while (true) {
                if (var5_5.hasNext()) {
                    confPid = var5_5.next();
                    factory = this.findFactoryConfigurations(ca, confPid, bundleContext.getBundle());
                    if (!factory.isEmpty()) {
                        created = false;
                        var9_12 = factory.iterator();
                        break block32;
                    } else {
                        singleton = this.findSingletonConfiguration(ca, confPid, bundleContext.getBundle());
                        if (singleton == null) {
                            var9_17 = false;
                            return var9_17;
                        }
                        try {
                            this.logger.log(InternalLogger.Level.DEBUG, "Configuring holder {0} with change count {1}", null, new Object[]{holder, singleton.getChangeCount()});
                            if (singleton != null && this.checkBundleLocation(singleton, bundleContext.getBundle())) {
                                changeCount = singleton.getChangeCount();
                                ref = this.getManagedServiceReference(bundleContext);
                                holder.configurationUpdated(new TargetedPID(singleton.getPid()), null, singleton.getProcessedProperties(ref), changeCount);
                                continue;
                            }
                            changeCount = false;
                            return changeCount;
                        }
                        catch (IllegalStateException e) {
                            var10_21 = false;
                            return var10_21;
                        }
                    }
                }
                var5_6 = confPids.isEmpty() == false;
                return var5_6;
            }
            finally {
                try {
                    bundleContext.ungetService(this.caReference);
                }
                catch (IllegalStateException var10_19) {}
            }
        }
        while (var9_12.hasNext()) {
            config = var9_12.next();
            try {
                this.logger.log(InternalLogger.Level.DEBUG, "Configuring holder {0} with change count {1}", null, new Object[]{holder, config.getChangeCount()});
                if (!this.checkBundleLocation(config, bundleContext.getBundle())) continue;
                changeCount = config.getChangeCount();
                ref = this.getManagedServiceReference(bundleContext);
                created |= holder.configurationUpdated(new TargetedPID(config.getPid()), new TargetedPID(config.getFactoryPid()), config.getProcessedProperties(ref), changeCount);
            }
            catch (IllegalStateException e) {}
        }
        if (!created) ** break;
        ** continue;
        var9_13 = false;
        return var9_13;
    }

    public void configurationEvent(ConfigurationEvent event) {
        TargetedPID pid = new TargetedPID(event.getPid());
        String rawFactoryPid = event.getFactoryPid();
        TargetedPID factoryPid = rawFactoryPid == null ? null : new TargetedPID(rawFactoryPid);
        Collection<ComponentHolder<?>> holders = this.getComponentHolders(factoryPid != null ? factoryPid : pid);
        this.logger.log(InternalLogger.Level.DEBUG, "configurationEvent: Handling {0} of Configuration PID={1} for component holders {2}", null, this.getEventType(event), pid, holders);
        block5: for (ComponentHolder<?> componentHolder : holders) {
            if (componentHolder.getComponentMetadata().isConfigurationIgnored()) continue;
            switch (event.getType()) {
                case 2: {
                    if (factoryPid == null && this.configureComponentHolder(componentHolder)) continue block5;
                    componentHolder.configurationDeleted(pid, factoryPid);
                    break;
                }
                case 1: {
                    ConfigurationInfo configInfo;
                    BundleContext bundleContext;
                    ComponentActivator activator = componentHolder.getActivator();
                    if (activator == null || (bundleContext = activator.getBundleContext()) == null) break;
                    TargetedPID targetedPid = factoryPid == null ? pid : factoryPid;
                    TargetedPID oldTargetedPID = componentHolder.getConfigurationTargetedPID(pid, factoryPid);
                    if (factoryPid == null && !targetedPid.equals(oldTargetedPID) && !targetedPid.bindsStronger(oldTargetedPID) || (configInfo = this.getConfigurationInfo(pid, targetedPid, componentHolder, bundleContext)) == null || !this.checkBundleLocation(configInfo.getBundleLocation(), bundleContext.getBundle())) continue block5;
                    componentHolder.configurationUpdated(pid, factoryPid, configInfo.getProps(), configInfo.getChangeCount());
                    break;
                }
                case 3: {
                    TargetedPID oldTargetedPID;
                    BundleContext bundleContext;
                    ComponentActivator activator = componentHolder.getActivator();
                    if (activator == null || (bundleContext = activator.getBundleContext()) == null) break;
                    TargetedPID targetedPid = factoryPid == null ? pid : factoryPid;
                    if (targetedPid.equals(oldTargetedPID = componentHolder.getConfigurationTargetedPID(pid, factoryPid))) {
                        ConfigurationInfo configInfo = this.getConfigurationInfo(pid, targetedPid, componentHolder, bundleContext);
                        if (configInfo == null) continue block5;
                        this.logger.log(InternalLogger.Level.DEBUG, "LocationChanged event, same targetedPID {0}, location now {1}, change count {2}", null, targetedPid, configInfo.getBundleLocation(), configInfo.getChangeCount());
                        if (configInfo.getProps() == null) {
                            throw new IllegalStateException("Existing Configuration with pid " + pid + " has had its properties set to null and location changed.  We expected a delete event first.");
                        }
                        if (this.checkBundleLocation(configInfo.getBundleLocation(), bundleContext.getBundle())) continue block5;
                        componentHolder.configurationDeleted(pid, factoryPid);
                        this.configureComponentHolder(componentHolder);
                        break;
                    }
                    boolean better = targetedPid.bindsStronger(oldTargetedPID);
                    if (better) {
                        ConfigurationInfo configInfo = this.getConfigurationInfo(pid, targetedPid, componentHolder, bundleContext);
                        if (configInfo == null) continue block5;
                        this.logger.log(InternalLogger.Level.DEBUG, "LocationChanged event, better targetedPID {0} compared to {1}, location now {2}, change count {3}", null, targetedPid, oldTargetedPID, configInfo.getBundleLocation(), configInfo.getChangeCount());
                        if (configInfo.getProps() == null) break;
                        if (!this.checkBundleLocation(configInfo.getBundleLocation(), bundleContext.getBundle())) continue block5;
                        if (oldTargetedPID != null) {
                            componentHolder.configurationDeleted(pid, factoryPid);
                        }
                        componentHolder.configurationUpdated(pid, factoryPid, configInfo.getProps(), configInfo.getChangeCount());
                        break;
                    }
                    this.logger.log(InternalLogger.Level.DEBUG, "LocationChanged event, worse targetedPID {0} compared to {1}, do nothing", null, targetedPid, oldTargetedPID);
                    break;
                }
                default: {
                    this.logger.log(InternalLogger.Level.WARN, "Unknown ConfigurationEvent type {0}", null, event.getType());
                }
            }
        }
    }

    protected abstract Collection<ComponentHolder<?>> getComponentHolders(TargetedPID var1);

    private String getEventType(ConfigurationEvent event) {
        switch (event.getType()) {
            case 1: {
                return "UPDATED";
            }
            case 2: {
                return "DELETED";
            }
            case 3: {
                return "LOCATION CHANGED";
            }
        }
        return "Unkown event type: " + event.getType();
    }

    /*
     * Exception decompiling
     */
    private ConfigurationInfo getConfigurationInfo(TargetedPID pid, TargetedPID targetedPid, ComponentHolder<?> componentHolder, BundleContext bundleContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ServiceReference<ManagedService> getManagedServiceReference(BundleContext bundleContext) {
        try {
            Collection<ServiceReference<ManagedService>> refs = bundleContext.getServiceReferences(ManagedService.class, "(&(service.bundleid=" + String.valueOf(bundleContext.getBundle().getBundleId()) + ")(!(service.pid=*)))");
            if (!refs.isEmpty()) {
                return refs.iterator().next();
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return bundleContext.registerService(ManagedService.class, new ManagedService(){

            @Override
            public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
            }
        }, null).getReference();
    }

    private String filter(String rawPid) {
        return "(service.pid=" + rawPid + ")";
    }

    public Configuration findSingletonConfiguration(ConfigurationAdmin ca, String pid, Bundle bundle) {
        String filter = this.getTargetedPidFilter(pid, bundle, "service.pid");
        Configuration[] cfg = this.findConfigurations(ca, filter);
        if (cfg == null) {
            return null;
        }
        String longest = null;
        Configuration best = null;
        for (Configuration config : cfg) {
            if (!this.checkBundleLocation(config, bundle)) continue;
            try {
                String testPid = config.getPid();
                if (longest != null && testPid.length() <= longest.length()) continue;
                longest = testPid;
                best = config;
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        return best;
    }

    private Collection<Configuration> findFactoryConfigurations(ConfigurationAdmin ca, String factoryPid, Bundle bundle) {
        String filter = this.getTargetedPidFilter(factoryPid, bundle, "service.factoryPid");
        Configuration[] configs = this.findConfigurations(ca, filter);
        if (configs == null) {
            return Collections.emptyList();
        }
        HashMap<String, Configuration> configsByPid = new HashMap<String, Configuration>();
        for (Configuration config : configs) {
            if (!this.checkBundleLocation(config, bundle)) continue;
            try {
                Configuration oldConfig = (Configuration)configsByPid.get(config.getPid());
                if (oldConfig == null) {
                    configsByPid.put(config.getPid(), config);
                    continue;
                }
                String newPid = config.getFactoryPid();
                String oldPid = oldConfig.getFactoryPid();
                if (newPid.length() <= oldPid.length()) continue;
                configsByPid.put(config.getPid(), config);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        return configsByPid.values();
    }

    private boolean checkBundleLocation(Configuration config, Bundle bundle) {
        if (config == null) {
            return false;
        }
        String configBundleLocation = null;
        try {
            configBundleLocation = config.getBundleLocation();
        }
        catch (IllegalStateException e) {
            return false;
        }
        return this.checkBundleLocation(configBundleLocation, bundle);
    }

    private boolean checkBundleLocation(String configBundleLocation, Bundle bundle) {
        boolean result = configBundleLocation == null ? true : (configBundleLocation.startsWith("?") ? (System.getSecurityManager() != null ? bundle.hasPermission(new ConfigurationPermission(configBundleLocation, "target")) : true) : configBundleLocation.equals(bundle.getLocation()));
        this.logger.log(InternalLogger.Level.DEBUG, "checkBundleLocation: location {0}, returning {1}", null, configBundleLocation, result);
        return result;
    }

    private Configuration[] findConfigurations(ConfigurationAdmin ca, String filter) {
        try {
            return ca.listConfigurations(filter);
        }
        catch (IOException ioe) {
            this.logger.log(InternalLogger.Level.WARN, "Problem listing configurations for filter={0}", ioe, filter);
        }
        catch (InvalidSyntaxException ise) {
            this.logger.log(InternalLogger.Level.ERROR, "Invalid Configuration selection filter {0}", ise, filter);
        }
        return null;
    }

    private String getTargetedPidFilter(String pid, Bundle bundle, String key) {
        String bsn = bundle.getSymbolicName();
        String version = bundle.getVersion().toString();
        String location = RegionConfigurationSupport.escape(bundle.getLocation());
        StringBuilder sb = new StringBuilder();
        sb.append("(|(");
        sb.append(key);
        sb.append('=');
        sb.append(pid);
        sb.append(")(");
        sb.append(key);
        sb.append('=');
        sb.append(pid);
        sb.append('|');
        sb.append(bsn);
        sb.append(")(");
        sb.append(key);
        sb.append('=');
        sb.append(pid);
        sb.append('|');
        sb.append(bsn);
        sb.append('|');
        sb.append(version);
        sb.append(")(");
        sb.append(key);
        sb.append('=');
        sb.append(pid);
        sb.append('|');
        sb.append(bsn);
        sb.append('|');
        sb.append(version);
        sb.append('|');
        sb.append(location);
        sb.append("))");
        return sb.toString();
    }

    static final String escape(String value) {
        StringBuilder sb = null;
        int index = 0;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case '\\': {
                    if (sb == null) {
                        sb = new StringBuilder();
                    }
                    sb.append(value, index, i);
                    sb.append('\\');
                    sb.append(c);
                    index = i + 1;
                }
            }
        }
        if (sb == null) {
            return value;
        }
        if (index < value.length()) {
            sb.append(value, index, value.length());
        }
        return sb.toString();
    }

    private ConfigurationAdmin getConfigAdmin(BundleContext bundleContext) {
        try {
            return bundleContext.getService(this.caReference);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    private static class ConfigurationInfo {
        private final Dictionary<String, Object> props;
        private final String bundleLocation;
        private final long changeCount;

        public ConfigurationInfo(Dictionary<String, Object> props, String bundleLocation, long changeCount) {
            this.props = props;
            this.bundleLocation = bundleLocation;
            this.changeCount = changeCount;
        }

        public long getChangeCount() {
            return this.changeCount;
        }

        public Dictionary<String, Object> getProps() {
            return this.props;
        }

        public String getBundleLocation() {
            return this.bundleLocation;
        }
    }
}

