/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.logger;

import org.apache.felix.scr.impl.logger.BundleLogger;
import org.apache.felix.scr.impl.logger.ComponentLogger;
import org.apache.felix.scr.impl.logger.ScrLogManager;
import org.apache.felix.scr.impl.logger.ScrLogger;
import org.apache.felix.scr.impl.manager.ScrConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

class ExtLogManager
extends ScrLogManager {
    public static String SCR_LOGGER_NAME = "org.apache.felix.scr.impl";
    public static String SCR_LOGGER_PREFIX = "org.apache.felix.scr.";
    private final Bundle bundle;

    ExtLogManager(BundleContext context, ScrConfiguration config) {
        super(context, config);
        this.bundle = context.getBundle();
    }

    @Override
    public ScrLogger scr() {
        return this.getLogger(this.bundle, SCR_LOGGER_NAME, ScrLogManager.ScrLoggerFacade.class);
    }

    @Override
    public BundleLogger bundle(Bundle bundle) {
        return this.getLogger(bundle, SCR_LOGGER_PREFIX.concat(bundle.getSymbolicName()), ScrLogManager.ScrLoggerFacade.class);
    }

    @Override
    public ComponentLogger component(Bundle bundle, String implementationClass, String componentName) {
        assert (bundle != null);
        assert (bundle.getSymbolicName() != null) : "scr requires recent bundles";
        assert (implementationClass != null);
        assert (componentName != null);
        String loggerName = SCR_LOGGER_PREFIX.concat(bundle.getSymbolicName()).concat(".").concat(componentName);
        ScrLogManager.ScrLoggerFacade logger = this.getLogger(bundle, loggerName, ScrLogManager.ScrLoggerFacade.class);
        logger.setPrefix("[" + componentName + "]");
        return logger;
    }

    @Override
    String componentPrefix(ScrLogManager.ScrLoggerFacade slf, long id2) {
        assert (slf.prefix != null);
        if (slf.prefix.indexOf(41) < 0) {
            return slf.prefix.replace("]", "(" + id2 + ")]");
        }
        return slf.prefix;
    }
}

