/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.helper;

import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.manager.ComponentActivator;
import org.apache.felix.scr.impl.manager.RegionConfigurationSupport;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ConfigAdminTracker {
    public static final String CONFIGURATION_ADMIN = "org.osgi.service.cm.ConfigurationAdmin";
    private final ServiceTracker<ConfigurationAdmin, RegionConfigurationSupport> configAdminTracker;

    public ConfigAdminTracker(final ComponentActivator componentActivator) {
        this.configAdminTracker = new ServiceTracker<ConfigurationAdmin, RegionConfigurationSupport>(componentActivator.getBundleContext(), CONFIGURATION_ADMIN, new ServiceTrackerCustomizer<ConfigurationAdmin, RegionConfigurationSupport>(){

            @Override
            public RegionConfigurationSupport addingService(ServiceReference<ConfigurationAdmin> reference) {
                boolean visible = false;
                try {
                    ConfigurationAdmin ca = componentActivator.getBundleContext().getService(reference);
                    if (ca != null) {
                        visible = true;
                        componentActivator.getBundleContext().ungetService(reference);
                    }
                }
                catch (Exception ex) {
                    componentActivator.getLogger().log(InternalLogger.Level.ERROR, "Configuration admin API visible to bundle " + componentActivator.getBundleContext().getBundle() + " is not the same as the Configuration Admin API visible to the SCR implementation.", ex);
                }
                if (!visible) {
                    return null;
                }
                return componentActivator.setRegionConfigurationSupport(reference);
            }

            @Override
            public void modifiedService(ServiceReference<ConfigurationAdmin> reference, RegionConfigurationSupport service) {
            }

            @Override
            public void removedService(ServiceReference<ConfigurationAdmin> reference, RegionConfigurationSupport rcs) {
                componentActivator.unsetRegionConfigurationSupport(rcs);
            }
        });
        this.configAdminTracker.open();
    }

    public void dispose() {
        this.configAdminTracker.close();
    }
}

