/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.io.PrintWriter;
import org.apache.felix.scr.impl.ComponentCommands;
import org.apache.felix.scr.info.ScrInfo;
import org.osgi.dto.DTO;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;

public class ComponentCommandsScrInfo
implements ScrInfo {
    private final ComponentCommands commands;
    private final BundleContext context;

    ComponentCommandsScrInfo(ComponentCommands commands, BundleContext context) {
        this.commands = commands;
        this.context = context;
    }

    @Override
    public void list(String bundleIdentifier, PrintWriter out) {
        CharSequence formatted;
        try {
            ComponentDescriptionDTO[] dtos;
            ComponentDescriptionDTO[] componentDescriptionDTOArray = dtos = bundleIdentifier == null ? this.commands.list() : this.commands.list(this.getBundleID(bundleIdentifier));
            formatted = dtos != null ? this.commands.format(dtos, 1) : "No components found for bundle  " + bundleIdentifier;
        }
        catch (Exception e) {
            throw new RuntimeException("Error listing or formatting SCR runtime information", e);
        }
        out.println(formatted);
    }

    private long getBundleID(String bundleIdentifier) {
        try {
            return Long.parseLong(bundleIdentifier);
        }
        catch (NumberFormatException e) {
            Bundle bundle = this.findBundle(bundleIdentifier);
            if (bundle == null) {
                throw new IllegalArgumentException("Cannot find bundle with ID: " + bundleIdentifier);
            }
            return bundle.getBundleId();
        }
    }

    @Override
    public void info(String componentId, PrintWriter out) {
        if (componentId != null) {
            DTO infoObj;
            try {
                long configId = Long.parseLong(componentId);
                infoObj = this.commands.info(configId);
            }
            catch (NumberFormatException e) {
                infoObj = this.commands.info(componentId);
            }
            CharSequence formatted = this.format(infoObj, out, 0);
            if (formatted == null) {
                out.println("No component found with ID " + componentId);
            } else {
                out.println(formatted);
            }
            return;
        }
        ComponentDescriptionDTO[] components = this.commands.list();
        if (components.length > 0) {
            for (ComponentDescriptionDTO componentDescriptionDTO : components) {
                out.println(this.format(componentDescriptionDTO, out, 0));
            }
        } else {
            out.println("No component found.");
        }
    }

    private CharSequence format(Object info, PrintWriter out, int level) {
        if (info != null) {
            try {
                return this.commands.format(info, level);
            }
            catch (Exception e) {
                throw new RuntimeException("Error formatting SCR runtime information", e);
            }
        }
        return null;
    }

    @Override
    public void config(PrintWriter out) {
        out.println(this.commands.config());
    }

    private Bundle findBundle(String bsn) {
        for (Bundle b : this.context.getBundles()) {
            if (!b.getSymbolicName().equals(bsn)) continue;
            return b;
        }
        return null;
    }
}

