/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath;

import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.BasicVariables;
import org.apache.commons.jxpath.CompiledExpression;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.IdentityManager;
import org.apache.commons.jxpath.JXPathContextFactory;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.KeyManager;
import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.PackageFunctions;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.Variables;
import org.apache.commons.jxpath.util.KeyManagerUtils;

public abstract class JXPathContext {
    private static JXPathContextFactory contextFactory;
    private static JXPathContext compilationContext;
    private static final PackageFunctions GENERIC_FUNCTIONS;
    protected JXPathContext parentContext;
    protected Object contextBean;
    protected Variables vars;
    protected Functions functions;
    protected AbstractFactory factory;
    protected IdentityManager idManager;
    protected KeyManager keyManager;
    protected HashMap decimalFormats;
    private Locale locale;
    private boolean lenientSet = false;
    private boolean lenient = false;

    public static JXPathContext newContext(Object contextBean) {
        return JXPathContext.getContextFactory().newContext(null, contextBean);
    }

    public static JXPathContext newContext(JXPathContext parentContext, Object contextBean) {
        return JXPathContext.getContextFactory().newContext(parentContext, contextBean);
    }

    private static JXPathContextFactory getContextFactory() {
        if (contextFactory == null) {
            contextFactory = JXPathContextFactory.newInstance();
        }
        return contextFactory;
    }

    protected JXPathContext(JXPathContext parentContext, Object contextBean) {
        this.parentContext = parentContext;
        this.contextBean = contextBean;
    }

    public JXPathContext getParentContext() {
        return this.parentContext;
    }

    public Object getContextBean() {
        return this.contextBean;
    }

    public abstract Pointer getContextPointer();

    public abstract JXPathContext getRelativeContext(Pointer var1);

    public void setVariables(Variables vars) {
        this.vars = vars;
    }

    public Variables getVariables() {
        if (this.vars == null) {
            this.vars = new BasicVariables();
        }
        return this.vars;
    }

    public void setFunctions(Functions functions) {
        this.functions = functions;
    }

    public Functions getFunctions() {
        if (this.functions != null) {
            return this.functions;
        }
        if (this.parentContext == null) {
            return GENERIC_FUNCTIONS;
        }
        return null;
    }

    public void setFactory(AbstractFactory factory) {
        this.factory = factory;
    }

    public AbstractFactory getFactory() {
        if (this.factory == null && this.parentContext != null) {
            return this.parentContext.getFactory();
        }
        return this.factory;
    }

    public synchronized void setLocale(Locale locale) {
        this.locale = locale;
    }

    public synchronized Locale getLocale() {
        if (this.locale == null) {
            if (this.parentContext != null) {
                return this.parentContext.getLocale();
            }
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    public synchronized void setDecimalFormatSymbols(String name, DecimalFormatSymbols symbols) {
        if (this.decimalFormats == null) {
            this.decimalFormats = new HashMap();
        }
        this.decimalFormats.put(name, symbols);
    }

    public synchronized DecimalFormatSymbols getDecimalFormatSymbols(String name) {
        if (this.decimalFormats == null) {
            return this.parentContext == null ? null : this.parentContext.getDecimalFormatSymbols(name);
        }
        return (DecimalFormatSymbols)this.decimalFormats.get(name);
    }

    public synchronized void setLenient(boolean lenient) {
        this.lenient = lenient;
        this.lenientSet = true;
    }

    public synchronized boolean isLenient() {
        if (!this.lenientSet && this.parentContext != null) {
            return this.parentContext.isLenient();
        }
        return this.lenient;
    }

    public static CompiledExpression compile(String xpath) {
        if (compilationContext == null) {
            compilationContext = JXPathContext.newContext(null);
        }
        return compilationContext.compilePath(xpath);
    }

    protected abstract CompiledExpression compilePath(String var1);

    public Object selectSingleNode(String xpath) {
        Pointer pointer = this.getPointer(xpath);
        return pointer == null ? null : pointer.getNode();
    }

    public List selectNodes(String xpath) {
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator iterator = this.iteratePointers(xpath);
        while (iterator.hasNext()) {
            Pointer pointer = (Pointer)iterator.next();
            list.add(pointer.getNode());
        }
        return list;
    }

    public abstract Object getValue(String var1);

    public abstract Object getValue(String var1, Class var2);

    public abstract void setValue(String var1, Object var2);

    public abstract Pointer createPath(String var1);

    public abstract Pointer createPathAndSetValue(String var1, Object var2);

    public abstract void removePath(String var1);

    public abstract void removeAll(String var1);

    public abstract Iterator iterate(String var1);

    public abstract Pointer getPointer(String var1);

    public abstract Iterator iteratePointers(String var1);

    public void setIdentityManager(IdentityManager idManager) {
        this.idManager = idManager;
    }

    public IdentityManager getIdentityManager() {
        if (this.idManager == null && this.parentContext != null) {
            return this.parentContext.getIdentityManager();
        }
        return this.idManager;
    }

    public Pointer getPointerByID(String id2) {
        IdentityManager manager = this.getIdentityManager();
        if (manager != null) {
            return manager.getPointerByID(this, id2);
        }
        throw new JXPathException("Cannot find an element by ID - no IdentityManager has been specified");
    }

    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public KeyManager getKeyManager() {
        if (this.keyManager == null && this.parentContext != null) {
            return this.parentContext.getKeyManager();
        }
        return this.keyManager;
    }

    public Pointer getPointerByKey(String key, String value) {
        KeyManager manager = this.getKeyManager();
        if (manager != null) {
            return manager.getPointerByKey(this, key, value);
        }
        throw new JXPathException("Cannot find an element by key - no KeyManager has been specified");
    }

    public NodeSet getNodeSetByKey(String key, Object value) {
        KeyManager manager = this.getKeyManager();
        if (manager != null) {
            return KeyManagerUtils.getExtendedKeyManager(manager).getNodeSetByKey(this, key, value);
        }
        throw new JXPathException("Cannot find an element by key - no KeyManager has been specified");
    }

    public void registerNamespace(String prefix, String namespaceURI) {
        throw new UnsupportedOperationException("Namespace registration is not implemented by " + this.getClass());
    }

    public String getNamespaceURI(String prefix) {
        throw new UnsupportedOperationException("Namespace registration is not implemented by " + this.getClass());
    }

    public String getPrefix(String namespaceURI) {
        throw new UnsupportedOperationException("Namespace registration is not implemented by " + this.getClass());
    }

    public void setNamespaceContextPointer(Pointer namespaceContextPointer) {
        throw new UnsupportedOperationException("Namespace registration is not implemented by " + this.getClass());
    }

    public Pointer getNamespaceContextPointer() {
        throw new UnsupportedOperationException("Namespace registration is not implemented by " + this.getClass());
    }

    static {
        GENERIC_FUNCTIONS = new PackageFunctions("", null);
    }
}

