/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.tikz;

import java.awt.Color;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.tikz.TikzGraphics;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UShape;

public class DriverUPathTikz
implements UDriver<TikzGraphics> {
    @Override
    public void draw(UShape shape, double x, double y, ColorMapper mapper2, UParam param, TikzGraphics tikz) {
        UPath path = (UPath)shape;
        HtmlColor back = param.getBackcolor();
        if (back instanceof HtmlColorGradient) {
            HtmlColorGradient gr = (HtmlColorGradient)back;
            Color color1 = mapper2.getMappedColor(gr.getColor1());
            Color color2 = mapper2.getMappedColor(gr.getColor2());
            tikz.setGradientColor(color1, color2, gr.getPolicy());
        } else {
            tikz.setFillColor(mapper2.getMappedColor(back));
        }
        tikz.setStrokeColor(mapper2.getMappedColor(param.getColor()));
        tikz.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDashTikz());
        tikz.upath(x, y, path);
    }
}

