/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.svg;

import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.svg.SvgGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;

public class DriverRectangleSvg
implements UDriver<SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverRectangleSvg(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper2, UParam param, SvgGraphics svg) {
        URectangle rect = (URectangle)ushape;
        double rx = rect.getRx();
        double ry = rect.getRy();
        double width = rect.getWidth();
        double height = rect.getHeight();
        HtmlColor back = param.getBackcolor();
        if (back instanceof HtmlColorGradient) {
            HtmlColorGradient gr = (HtmlColorGradient)back;
            String id2 = svg.createSvgGradient(StringUtils.getAsHtml(mapper2.getMappedColor(gr.getColor1())), StringUtils.getAsHtml(mapper2.getMappedColor(gr.getColor2())), gr.getPolicy());
            svg.setFillColor("url(#" + id2 + ")");
            DriverRectangleSvg.applyColor(svg, mapper2, param);
        } else {
            String backcolor = StringUtils.getAsSvg(mapper2, back);
            svg.setFillColor(backcolor);
            DriverRectangleSvg.applyColor(svg, mapper2, param);
        }
        svg.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDasharraySvg());
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            Rectangle2D.Double r = clip.getClippedRectangle(new Rectangle2D.Double(x, y, width, height));
            x = r.x;
            y = r.y;
            width = r.width;
            height = r.height;
            if (height <= 0.0) {
                return;
            }
        }
        svg.svgRectangle(x, y, width, height, rx / 2.0, ry / 2.0, rect.getDeltaShadow(), rect.getComment());
    }

    public static void applyColor(SvgGraphics svg, ColorMapper mapper2, UParam param) {
        HtmlColor color = param.getColor();
        if (color instanceof HtmlColorGradient) {
            HtmlColorGradient gr = (HtmlColorGradient)color;
            String id2 = svg.createSvgGradient(StringUtils.getAsHtml(mapper2.getMappedColor(gr.getColor1())), StringUtils.getAsHtml(mapper2.getMappedColor(gr.getColor2())), gr.getPolicy());
            svg.setStrokeColor("url(#" + id2 + ")");
        } else {
            svg.setStrokeColor(StringUtils.getAsSvg(mapper2, color));
        }
    }
}

