/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.svg;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.svg.SvgGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.g2d.DriverShadowedG2d;

public class DriverPathSvg
extends DriverShadowedG2d
implements UDriver<SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverPathSvg(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper2, UParam param, SvgGraphics svg) {
        UPath shape = (UPath)ushape;
        UClip clip = this.clipContainer.getClip();
        if (clip != null && !clip.isInside(x, y, shape)) {
            return;
        }
        String color = StringUtils.getAsSvg(mapper2, param.getColor());
        if (shape.isOpenIconic()) {
            svg.setFillColor(color);
            svg.setStrokeColor("");
            svg.setStrokeWidth(0.0, "");
        } else {
            HtmlColor back = param.getBackcolor();
            if (back instanceof HtmlColorGradient) {
                HtmlColorGradient gr = (HtmlColorGradient)back;
                String id2 = svg.createSvgGradient(StringUtils.getAsHtml(mapper2.getMappedColor(gr.getColor1())), StringUtils.getAsHtml(mapper2.getMappedColor(gr.getColor2())), gr.getPolicy());
                svg.setFillColor("url(#" + id2 + ")");
            } else {
                String backcolor = StringUtils.getAsSvg(mapper2, back);
                svg.setFillColor(backcolor);
            }
            svg.setStrokeColor(color);
            svg.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDasharraySvg());
        }
        svg.svgPath(x, y, shape, shape.getDeltaShadow());
    }
}

