/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.eps;

import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;

public class DriverRectangleEps
implements UDriver<EpsGraphics> {
    private final ClipContainer clipContainer;

    public DriverRectangleEps(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper2, UParam param, EpsGraphics eps) {
        HtmlColor back;
        URectangle rect = (URectangle)ushape;
        double width = rect.getWidth();
        double height = rect.getHeight();
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            Rectangle2D.Double orig = new Rectangle2D.Double(x, y, width, height);
            Rectangle2D.Double r = clip.getClippedRectangle(orig);
            if (r.height < 0.0) {
                return;
            }
            x = r.x;
            y = r.y;
            width = r.width;
            height = r.height;
        }
        double rx = rect.getRx();
        double ry = rect.getRy();
        if (rect.getDeltaShadow() != 0.0) {
            eps.epsRectangleShadow(x, y, width, height, rx / 2.0, ry / 2.0, rect.getDeltaShadow());
        }
        if ((back = param.getBackcolor()) instanceof HtmlColorGradient) {
            eps.setStrokeColor(mapper2.getMappedColor(param.getColor()));
            eps.epsRectangle(x, y, width, height, rx / 2.0, ry / 2.0, (HtmlColorGradient)back, mapper2);
        } else {
            eps.setStrokeColor(mapper2.getMappedColor(param.getColor()));
            eps.setFillColor(mapper2.getMappedColor(param.getBackcolor()));
            eps.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDashVisible(), param.getStroke().getDashSpace());
            eps.epsRectangle(x, y, width, height, rx / 2.0, ry / 2.0);
        }
    }
}

