/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.tim.Eater;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.tim.expression.TokenStack;

public class EaterFunctionCall
extends Eater {
    private final List<TValue> values = new ArrayList<TValue>();
    private final boolean isLegacyDefine;
    private final boolean unquoted;

    public EaterFunctionCall(String s, boolean isLegacyDefine, boolean unquoted) {
        super(s);
        this.isLegacyDefine = isLegacyDefine;
        this.unquoted = unquoted;
    }

    @Override
    public void execute(TContext context, TMemory memory) throws EaterException {
        char ch;
        this.skipUntilChar('(');
        this.checkAndEatChar('(');
        this.skipSpaces();
        if (this.peekChar() == ')') {
            this.checkAndEatChar(')');
            return;
        }
        do {
            this.skipSpaces();
            if (this.isLegacyDefine || this.unquoted) {
                String tmp = this.eatAndGetOptionalQuotedString();
                String tmp2 = context.applyFunctionsAndVariables(memory, tmp);
                TValue result = TValue.fromString(tmp2);
                this.values.add(result);
            } else {
                TokenStack tokens = TokenStack.eatUntilCloseParenthesisOrComma(this).withoutSpace();
                tokens.guessFunctions();
                TValue result = tokens.getResult(context, memory);
                this.values.add(result);
            }
            this.skipSpaces();
        } while ((ch = this.eatOneChar()) == ',');
        if (ch != ')') {
            throw new EaterException("call001");
        }
    }

    public final List<TValue> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public final String getEndOfLine() throws EaterException {
        return this.eatAllToEnd();
    }
}

