/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc2;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.DefinitionsContainer;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.DefinesGet;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc.IfManagerFilter;
import net.sourceforge.plantuml.preproc.ImportedFiles;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineNumbered;
import net.sourceforge.plantuml.preproc2.PreprocessorDefineApply;
import net.sourceforge.plantuml.preproc2.PreprocessorDefineLearner;
import net.sourceforge.plantuml.preproc2.PreprocessorInclude;
import net.sourceforge.plantuml.preproc2.PreprocessorMode;
import net.sourceforge.plantuml.preproc2.PreprocessorModeSet;
import net.sourceforge.plantuml.preproc2.ReadFilterAnd;
import net.sourceforge.plantuml.preproc2.ReadLineAddConfig;
import net.sourceforge.plantuml.preproc2.ReadLineQuoteComment;
import net.sourceforge.plantuml.preproc2.SubPreprocessor;

public class Preprocessor
implements ReadLineNumbered {
    private final ReadLine source;
    private final PreprocessorInclude include;
    private final PreprocessorModeSet mode;
    private final ReadLine sourceV2;

    public Preprocessor(List<String> config, ReadLine reader, String charset, Defines defines, DefinitionsContainer definitionsContainer, ImportedFiles importedFiles) throws IOException {
        this(config, reader, charset, new DefinesGet(defines), definitionsContainer, new HashSet<FileWithSuffix>(), importedFiles, true);
    }

    Preprocessor(List<String> config, ReadLine reader, String charset, DefinesGet defines, DefinitionsContainer definitionsContainer, Set<FileWithSuffix> filesUsedGlobal, ImportedFiles importedFiles, boolean doSaveState) throws IOException {
        this.mode = definitionsContainer;
        if (doSaveState) {
            defines.saveState();
        }
        ReadFilterAnd filtersV2 = new ReadFilterAnd();
        filtersV2.add(new ReadLineQuoteComment(true));
        filtersV2.add(new ReadLineAddConfig(config));
        this.sourceV2 = filtersV2.applyFilter(reader);
        ReadFilterAnd filters = new ReadFilterAnd();
        filters.add(new ReadLineQuoteComment(false));
        this.include = new PreprocessorInclude(config, charset, defines, definitionsContainer, importedFiles, filesUsedGlobal);
        filters.add(new ReadLineAddConfig(config));
        filters.add(new IfManagerFilter(defines));
        filters.add(new PreprocessorDefineApply(defines));
        filters.add(new SubPreprocessor(charset, definitionsContainer));
        filters.add(new PreprocessorDefineLearner(defines, importedFiles.getCurrentDir()));
        filters.add(this.include);
        this.source = filters.applyFilter(reader);
    }

    private boolean isV2() {
        return this.mode != null && this.mode.getPreprocessorMode() == PreprocessorMode.V2_NEW_TIM;
    }

    @Override
    public StringLocated readLine() throws IOException {
        if (this.isV2()) {
            return this.sourceV2.readLine();
        }
        return this.source.readLine();
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public Set<FileWithSuffix> getFilesUsed() {
        return Collections.unmodifiableSet(this.include.getFilesUsedGlobal());
    }
}

