/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.Color;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.ugraphic.ColorMapper;

public class HtmlColorGradient
implements HtmlColor {
    private final HtmlColor color1;
    private final HtmlColor color2;
    private final char policy;

    public HtmlColorGradient(HtmlColor color1, HtmlColor color2, char policy) {
        if (color1 == null || color2 == null) {
            throw new IllegalArgumentException();
        }
        if (color1 instanceof HtmlColorGradient) {
            color1 = ((HtmlColorGradient)color1).color1;
        }
        if (color2 instanceof HtmlColorGradient) {
            color2 = ((HtmlColorGradient)color2).color2;
        }
        this.color1 = color1;
        this.color2 = color2;
        this.policy = policy;
    }

    public final HtmlColor getColor1() {
        return this.color1;
    }

    public final HtmlColor getColor2() {
        return this.color2;
    }

    public final Color getColor(ColorMapper mapper2, double coeff) {
        if (coeff > 1.0 || coeff < 0.0) {
            throw new IllegalArgumentException("c=" + coeff);
        }
        Color c1 = mapper2.getMappedColor(this.color1);
        Color c2 = mapper2.getMappedColor(this.color2);
        int vred = c2.getRed() - c1.getRed();
        int vgreen = c2.getGreen() - c1.getGreen();
        int vblue = c2.getBlue() - c1.getBlue();
        int red = c1.getRed() + (int)(coeff * (double)vred);
        int green = c1.getGreen() + (int)(coeff * (double)vgreen);
        int blue = c1.getBlue() + (int)(coeff * (double)vblue);
        return new Color(red, green, blue);
    }

    public final char getPolicy() {
        return this.policy;
    }
}

