/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import net.sourceforge.plantuml.StringUtils;

public class Code
implements Comparable<Code> {
    private final String fullName;
    private final String separator;

    private Code(String fullName, String separator) {
        if (fullName == null) {
            throw new IllegalArgumentException();
        }
        this.fullName = fullName;
        this.separator = separator;
    }

    public Code removeMemberPart() {
        int x = this.fullName.lastIndexOf("::");
        if (x == -1) {
            return null;
        }
        return new Code(this.fullName.substring(0, x), this.separator);
    }

    public String getPortMember() {
        int x = this.fullName.lastIndexOf("::");
        if (x == -1) {
            return null;
        }
        return this.fullName.substring(x + 2);
    }

    public Code withSeparator(String separator) {
        if (separator == null) {
            throw new IllegalArgumentException();
        }
        if (this.separator != null && !this.separator.equals(separator)) {
            throw new IllegalStateException();
        }
        return new Code(this.fullName, separator);
    }

    public static Code of(String code) {
        return Code.of(code, null);
    }

    public static Code of(String code, String separator) {
        if (code == null) {
            return null;
        }
        return new Code(code, separator);
    }

    public final String getFullName() {
        return this.fullName;
    }

    public String toString() {
        return this.fullName + "(" + this.separator + ")";
    }

    public int hashCode() {
        return this.fullName.hashCode();
    }

    public boolean equals(Object obj) {
        Code other = (Code)obj;
        return this.fullName.equals(other.fullName);
    }

    public Code addSuffix(String suffix) {
        return new Code(this.fullName + suffix, this.separator);
    }

    @Override
    public int compareTo(Code other) {
        return this.fullName.compareTo(other.fullName);
    }

    public Code eventuallyRemoveStartingAndEndingDoubleQuote(String format) {
        return Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(this.fullName, format), this.separator);
    }

    public final String getSeparator() {
        return this.separator;
    }

    public String getLastPart() {
        int x = this.fullName.lastIndexOf(this.separator);
        return this.fullName.substring(x + this.separator.length());
    }
}

