/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.braille;

import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.braille.BrailleGrid;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;

public class DriverRectangleBraille
implements UDriver<BrailleGrid> {
    private final ClipContainer clipContainer;

    public DriverRectangleBraille(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper2, UParam param, BrailleGrid grid) {
        URectangle rect = (URectangle)ushape;
        double width = rect.getWidth();
        double height = rect.getHeight();
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            Rectangle2D.Double r = clip.getClippedRectangle(new Rectangle2D.Double(x, y, width, height));
            x = r.x;
            y = r.y;
            width = r.width;
            height = r.height;
            if (height <= 0.0) {
                return;
            }
        }
        grid.rectangle(x, y, width, height);
    }
}

