/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.braille;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import net.sourceforge.plantuml.braille.BrailleGrid;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class DriverPolygonBraille
implements UDriver<BrailleGrid> {
    private final ClipContainer clipContainer;

    public DriverPolygonBraille(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper2, UParam param, BrailleGrid grid) {
        UPolygon shape = (UPolygon)ushape;
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        boolean i = false;
        for (Point2D point2D : shape.getPoints()) {
            points.add(new UTranslate(x, y).getTranslated(point2D));
        }
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            for (Point2D pt : points) {
                if (clip.isInside(pt)) continue;
                return;
            }
        }
        grid.drawPolygon(points);
    }
}

