/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.actions.generator.plantuml;

import com.google.common.base.Objects;
import java.util.Arrays;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.ActionList;
import org.eclipse.comma.actions.actions.AnyEvent;
import org.eclipse.comma.actions.actions.AssignmentAction;
import org.eclipse.comma.actions.actions.CommandEvent;
import org.eclipse.comma.actions.actions.CommandReply;
import org.eclipse.comma.actions.actions.EVENT_KIND;
import org.eclipse.comma.actions.actions.EventCall;
import org.eclipse.comma.actions.actions.EventPattern;
import org.eclipse.comma.actions.actions.IfAction;
import org.eclipse.comma.actions.actions.NotificationEvent;
import org.eclipse.comma.actions.actions.PCElement;
import org.eclipse.comma.actions.actions.PCFragmentReference;
import org.eclipse.comma.actions.actions.ParallelComposition;
import org.eclipse.comma.actions.actions.RecordFieldAssignmentAction;
import org.eclipse.comma.actions.actions.SignalEvent;
import org.eclipse.comma.actions.utilities.ActionsUtilities;
import org.eclipse.comma.actions.utilities.EventPatternMultiplicity;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.generator.plantuml.ExpressionsUmlGenerator;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;

public class ActionsUmlGenerator
extends ExpressionsUmlGenerator {
    public ActionsUmlGenerator(String fileName, IFileSystemAccess fsa) {
        super(fileName, fsa);
    }

    protected CharSequence _generateAction(AssignmentAction a) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = a.getAssignment().getName();
        _builder.append(_name);
        _builder.append(" := ");
        CharSequence _generateExpression = this.generateExpression(a.getExp());
        _builder.append((Object)_generateExpression);
        _builder.append("; ");
        return _builder;
    }

    protected CharSequence _generateAction(RecordFieldAssignmentAction a) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateExpression = this.generateExpression(a.getFieldAccess());
        _builder.append((Object)_generateExpression);
        _builder.append(" := ");
        CharSequence _generateExpression_1 = this.generateExpression(a.getExp());
        _builder.append((Object)_generateExpression_1);
        _builder.append("; ");
        return _builder;
    }

    protected CharSequence _generateAction(IfAction a) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if ");
        CharSequence _generateExpression = this.generateExpression(a.getGuard());
        _builder.append((Object)_generateExpression);
        _builder.append(" then ");
        EList<Action> _actions = a.getThenList().getActions();
        for (Action act : _actions) {
            CharSequence _generateAction = this.generateAction(act);
            _builder.append((Object)_generateAction);
        }
        ActionList _elseList = a.getElseList();
        boolean bl = _tripleNotEquals = _elseList != null;
        if (_tripleNotEquals) {
            _builder.append(" else ");
            EList<Action> _actions_1 = a.getElseList().getActions();
            for (Action act_1 : _actions_1) {
                CharSequence _generateAction_1 = this.generateAction(act_1);
                _builder.append((Object)_generateAction_1);
                _builder.append(" ");
            }
        }
        _builder.append("fi ");
        return _builder;
    }

    protected CharSequence _generateAction(CommandReply a) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("reply");
        int _size = a.getParameters().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("(");
            CharSequence _generateExpression = this.generateExpression((Expression)a.getParameters().get(0));
            _builder.append((Object)_generateExpression);
            _builder.append(")");
        }
        _builder.append(" ");
        return _builder;
    }

    protected CharSequence _generateAction(EventCall a) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        EObject _eContainer = a.getEvent().eContainer();
        String _name = ((Signature)_eContainer).getName();
        _builder.append(_name);
        _builder.append("::");
        String _name_1 = a.getEvent().getName();
        _builder.append(_name_1);
        int _size = a.getParameters().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("(");
            EList _parameters = a.getParameters();
            boolean _hasElements = false;
            for (Expression p : _parameters) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _generateExpression = this.generateExpression(p);
                _builder.append((Object)_generateExpression);
            }
            _builder.append(")");
            String _printMultiplicity = this.printMultiplicity(ActionsUtilities.getNormalizedMultiplicity(a));
            _builder.append(_printMultiplicity);
        }
        _builder.append(" ");
        return _builder;
    }

    protected CharSequence _generateAction(PCFragmentReference a) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("fragment ");
        String _name = a.getFragment().getName();
        _builder.append(_name);
        return _builder;
    }

    protected CharSequence _generateAction(ParallelComposition a) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("any order(");
        EList _components = a.getComponents();
        boolean _hasElements = false;
        for (PCElement c : _components) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _generateAction = this.generateAction(c);
            _builder.append((Object)_generateAction);
        }
        _builder.append(") ");
        return _builder;
    }

    public String printMultiplicity(EventPatternMultiplicity m) {
        if (m.lower == m.upper) {
            String _xifexpression = null;
            if (m.lower == 1L) {
                StringConcatenation _builder = new StringConcatenation();
                _xifexpression = _builder.toString();
            } else {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("[");
                _builder_1.append((Object)m.lower);
                _builder_1.append("]");
                _xifexpression = _builder_1.toString();
            }
            return _xifexpression;
        }
        if (m.upper == -1L) {
            if (m.lower == 0L) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("[*]");
                return _builder_2.toString();
            }
            if (m.lower == 1L) {
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append("[+]");
                return _builder_3.toString();
            }
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append("[");
            _builder_4.append((Object)m.lower);
            _builder_4.append("-*]");
            return _builder_4.toString();
        }
        if (m.lower == 0L && m.upper == 1L) {
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append("[?]");
            return _builder_5.toString();
        }
        StringConcatenation _builder_6 = new StringConcatenation();
        _builder_6.append("[");
        _builder_6.append((Object)m.lower);
        _builder_6.append("-");
        _builder_6.append((Object)m.upper);
        _builder_6.append("]");
        return _builder_6.toString();
    }

    protected CharSequence _eventToUML(CommandEvent e, boolean expected) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Client ->");
        if (!expected) {
            _builder.append("x");
        }
        _builder.append(" Server: command ");
        EObject _eContainer = e.getEvent().eContainer();
        String _name = ((Signature)_eContainer).getName();
        _builder.append(_name);
        _builder.append("_");
        String _name_1 = e.getEvent().getName();
        _builder.append(_name_1);
        int _size = e.getParameters().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("(");
            EList _parameters = e.getParameters();
            boolean _hasElements = false;
            for (Expression p : _parameters) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _generateExpression = this.generateExpression(p);
                _builder.append((Object)_generateExpression);
            }
            _builder.append(")");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _eventToUML(SignalEvent e, boolean expected) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Client ->>");
        if (!expected) {
            _builder.append("x");
        }
        _builder.append(" Server: signal ");
        EObject _eContainer = e.getEvent().eContainer();
        String _name = ((Signature)_eContainer).getName();
        _builder.append(_name);
        _builder.append("_");
        String _name_1 = e.getEvent().getName();
        _builder.append(_name_1);
        int _size = e.getParameters().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("(");
            EList _parameters = e.getParameters();
            boolean _hasElements = false;
            for (Expression p : _parameters) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _generateExpression = this.generateExpression(p);
                _builder.append((Object)_generateExpression);
            }
            _builder.append(")");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _eventToUML(CommandReply e, boolean expected) {
        CommandEvent _command;
        boolean _tripleNotEquals;
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Server -->");
        if (!expected) {
            _builder.append("x");
        }
        _builder.append(" Client: reply ");
        int _size = e.getParameters().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("(");
            CharSequence _generateExpression = this.generateExpression((Expression)e.getParameters().get(0));
            _builder.append((Object)_generateExpression);
            _builder.append(")");
        }
        boolean bl2 = _tripleNotEquals = (_command = e.getCommand()) != null;
        if (_tripleNotEquals) {
            boolean _greaterThan_1;
            _builder.append(" to command ");
            EObject _eContainer = e.getCommand().getEvent().eContainer();
            String _name = ((Signature)_eContainer).getName();
            _builder.append(_name);
            _builder.append("_");
            String _name_1 = e.getCommand().getEvent().getName();
            _builder.append(_name_1);
            int _size_1 = e.getCommand().getParameters().size();
            boolean bl3 = _greaterThan_1 = _size_1 > 0;
            if (_greaterThan_1) {
                _builder.append("(");
                EList _parameters = e.getCommand().getParameters();
                boolean _hasElements = false;
                for (Expression p : _parameters) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    CharSequence _generateExpression_1 = this.generateExpression(p);
                    _builder.append((Object)_generateExpression_1);
                }
                _builder.append(")");
            }
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _eventToUML(NotificationEvent e, boolean expected) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Client ");
        if (!expected) {
            _builder.append("x");
        }
        _builder.append("//- Server: notification ");
        EObject _eContainer = e.getEvent().eContainer();
        String _name = ((Signature)_eContainer).getName();
        _builder.append(_name);
        _builder.append("_");
        String _name_1 = e.getEvent().getName();
        _builder.append(_name_1);
        int _size = e.getParameters().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("(");
            EList _parameters = e.getParameters();
            boolean _hasElements = false;
            for (Expression p : _parameters) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _generateExpression = this.generateExpression(p);
                _builder.append((Object)_generateExpression);
            }
            _builder.append(")");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _eventToUML(AnyEvent e, boolean expected) {
        StringConcatenation _builder = new StringConcatenation();
        EVENT_KIND _kind = e.getKind();
        boolean _equals = Objects.equal((Object)((Object)_kind), (Object)((Object)EVENT_KIND.CALL));
        if (_equals) {
            _builder.append("Client ->");
            if (!expected) {
                _builder.append("x");
            }
            _builder.append(" Server: any command");
        }
        _builder.newLineIfNotEmpty();
        EVENT_KIND _kind_1 = e.getKind();
        boolean _equals_1 = Objects.equal((Object)((Object)_kind_1), (Object)((Object)EVENT_KIND.SIGNAL));
        if (_equals_1) {
            _builder.append("Client ->>");
            if (!expected) {
                _builder.append("x");
            }
            _builder.append(" Server: any signal");
        }
        _builder.newLineIfNotEmpty();
        EVENT_KIND _kind_2 = e.getKind();
        boolean _equals_2 = Objects.equal((Object)((Object)_kind_2), (Object)((Object)EVENT_KIND.NOTIFICATION));
        if (_equals_2) {
            _builder.append("Client ");
            if (!expected) {
                _builder.append("x");
            }
            _builder.append("//- Server: any notification");
        }
        _builder.newLineIfNotEmpty();
        EVENT_KIND _kind_3 = e.getKind();
        boolean _equals_3 = Objects.equal((Object)((Object)_kind_3), (Object)((Object)EVENT_KIND.EVENT));
        if (_equals_3) {
            _builder.append("Client <->");
            if (!expected) {
                _builder.append("x");
            }
            _builder.append(" Server: any event");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateAction(EObject a) {
        if (a instanceof CommandReply) {
            return this._generateAction((CommandReply)a);
        }
        if (a instanceof EventCall) {
            return this._generateAction((EventCall)a);
        }
        if (a instanceof AssignmentAction) {
            return this._generateAction((AssignmentAction)a);
        }
        if (a instanceof IfAction) {
            return this._generateAction((IfAction)a);
        }
        if (a instanceof PCFragmentReference) {
            return this._generateAction((PCFragmentReference)a);
        }
        if (a instanceof ParallelComposition) {
            return this._generateAction((ParallelComposition)a);
        }
        if (a instanceof RecordFieldAssignmentAction) {
            return this._generateAction((RecordFieldAssignmentAction)a);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(a).toString());
    }

    public CharSequence eventToUML(EventPattern e, boolean expected) {
        if (e instanceof CommandEvent) {
            return this._eventToUML((CommandEvent)e, expected);
        }
        if (e instanceof CommandReply) {
            return this._eventToUML((CommandReply)e, expected);
        }
        if (e instanceof NotificationEvent) {
            return this._eventToUML((NotificationEvent)e, expected);
        }
        if (e instanceof SignalEvent) {
            return this._eventToUML((SignalEvent)e, expected);
        }
        if (e instanceof AnyEvent) {
            return this._eventToUML((AnyEvent)e, expected);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e, expected).toString());
    }
}

