/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.internal.debug.core.HeapWalkingManager;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class HeapWalkingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button fShowReferencesInVarView;
    private Text fAllReferencesMaxCount;
    private Text fAllInstancesMaxCount;
    private Map<Object, String> fErrorMessages;

    public void init(IWorkbench workbench) {
        this.fErrorMessages = new HashMap<Object, String>();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.JAVA_HEAPWALKING_PREFERENCE_PAGE);
    }

    protected Control createContents(Composite parent) {
        Composite comp = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808);
        SWTFactory.createWrapLabel((Composite)comp, (String)DebugUIMessages.HeapWalkingPreferencePage_0, (int)1, (int)300);
        SWTFactory.createVerticalSpacer((Composite)comp, (int)2);
        this.fShowReferencesInVarView = SWTFactory.createCheckButton((Composite)comp, (String)DebugUIMessages.HeapWalkingPreferencePage_5, null, (boolean)HeapWalkingManager.getDefault().isShowReferenceInVarView(), (int)1);
        SWTFactory.createVerticalSpacer((Composite)comp, (int)2);
        Group group = SWTFactory.createGroup((Composite)comp, (String)DebugUIMessages.HeapWalkingPreferencePage_3, (int)2, (int)1, (int)768);
        SWTFactory.createLabel((Composite)group, (String)DebugUIMessages.HeapWalkingPreferencePage_4, (int)2);
        SWTFactory.createLabel((Composite)group, (String)DebugUIMessages.HeapWalkingPreferencePage_1, (int)1);
        this.fAllInstancesMaxCount = SWTFactory.createSingleText((Composite)group, (int)1);
        this.fAllInstancesMaxCount.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    int result = Integer.parseInt(HeapWalkingPreferencePage.this.fAllInstancesMaxCount.getText());
                    if (result < 0) {
                        throw new NumberFormatException();
                    }
                    HeapWalkingPreferencePage.this.clearErrorMessage(HeapWalkingPreferencePage.this.fAllInstancesMaxCount);
                }
                catch (NumberFormatException numberFormatException) {
                    HeapWalkingPreferencePage.this.setErrorMessage(HeapWalkingPreferencePage.this.fAllInstancesMaxCount, DebugUIMessages.HeapWalkingPreferencePage_6);
                }
            }
        });
        this.fAllInstancesMaxCount.setText("" + HeapWalkingManager.getDefault().getAllInstancesMaxCount());
        SWTFactory.createLabel((Composite)group, (String)DebugUIMessages.HeapWalkingPreferencePage_2, (int)1);
        this.fAllReferencesMaxCount = SWTFactory.createSingleText((Composite)group, (int)1);
        this.fAllReferencesMaxCount.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    int result = Integer.parseInt(HeapWalkingPreferencePage.this.fAllReferencesMaxCount.getText());
                    if (result < 0) {
                        throw new NumberFormatException();
                    }
                    HeapWalkingPreferencePage.this.clearErrorMessage(HeapWalkingPreferencePage.this.fAllReferencesMaxCount);
                }
                catch (NumberFormatException numberFormatException) {
                    HeapWalkingPreferencePage.this.setErrorMessage(HeapWalkingPreferencePage.this.fAllReferencesMaxCount, DebugUIMessages.HeapWalkingPreferencePage_6);
                }
            }
        });
        this.fAllReferencesMaxCount.setText("" + HeapWalkingManager.getDefault().getAllReferencesMaxCount());
        return comp;
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (result) {
            int maxReferences;
            HeapWalkingManager.getDefault().setShowReferenceInVarView(this.fShowReferencesInVarView.getSelection());
            try {
                maxReferences = Integer.parseInt(this.fAllReferencesMaxCount.getText());
                HeapWalkingManager.getDefault().setAllReferencesMaxCount(maxReferences);
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(this.fAllReferencesMaxCount, DebugUIMessages.HeapWalkingPreferencePage_6);
                return false;
            }
            try {
                maxReferences = Integer.parseInt(this.fAllInstancesMaxCount.getText());
                HeapWalkingManager.getDefault().setAllInstancesMaxCount(maxReferences);
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(this.fAllInstancesMaxCount, DebugUIMessages.HeapWalkingPreferencePage_6);
                result = false;
            }
            HeapWalkingManager.getDefault().setShowReferenceInVarView(this.fShowReferencesInVarView.getSelection());
        }
        return result;
    }

    private void setErrorMessage(Object cause, String message) {
        this.fErrorMessages.put(cause, message);
        this.setErrorMessage(message);
        this.setValid(false);
    }

    private void clearErrorMessage(Object cause) {
        this.fErrorMessages.remove(cause);
        Iterator<String> iter = this.fErrorMessages.values().iterator();
        if (iter.hasNext()) {
            this.setErrorMessage(iter.next());
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }

    protected void performDefaults() {
        HeapWalkingManager.getDefault().resetToDefaultSettings();
        this.fAllReferencesMaxCount.setText(Integer.toString(HeapWalkingManager.getDefault().getAllReferencesMaxCount()));
        this.fAllInstancesMaxCount.setText(Integer.toString(HeapWalkingManager.getDefault().getAllReferencesMaxCount()));
        this.fShowReferencesInVarView.setSelection(HeapWalkingManager.getDefault().isShowReferenceInVarView());
    }

    public void dispose() {
        super.dispose();
        this.fErrorMessages.clear();
    }
}

