/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.types.generator;

import java.util.Arrays;
import java.util.List;
import org.eclipse.comma.types.types.Dimension;
import org.eclipse.comma.types.types.EnumElement;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.MapTypeConstructor;
import org.eclipse.comma.types.types.MapTypeDecl;
import org.eclipse.comma.types.types.RecordField;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.TypeReference;
import org.eclipse.comma.types.types.VectorTypeConstructor;
import org.eclipse.comma.types.types.VectorTypeDecl;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;

public class TypesCommaGenerator {
    protected CharSequence _typeToCommaSyntax(TypeReference t) {
        return this.typeToCommaSyntax(t.getType());
    }

    protected CharSequence _typeToCommaSyntax(TypeDecl t) {
        return this.generateTypeName(t);
    }

    protected CharSequence _typeToCommaSyntax(VectorTypeConstructor t) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _typeToCommaSyntax = this.typeToCommaSyntax(t.getType());
        _builder.append((Object)_typeToCommaSyntax);
        EList<Dimension> _dimensions = t.getDimensions();
        for (Dimension d : _dimensions) {
            _builder.append("[]");
        }
        return _builder;
    }

    protected CharSequence _typeToCommaSyntax(MapTypeConstructor t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("map<");
        CharSequence _typeToCommaSyntax = this.typeToCommaSyntax(t.getType());
        _builder.append((Object)_typeToCommaSyntax);
        _builder.append(", ");
        CharSequence _typeToCommaSyntax_1 = this.typeToCommaSyntax(t.getValueType());
        _builder.append((Object)_typeToCommaSyntax_1);
        _builder.append(">");
        return _builder;
    }

    public CharSequence generateTypeName(TypeDecl t) {
        return t.getName();
    }

    protected CharSequence _generateDefaultValue(TypeReference t) {
        return this.generateDefaultValue(t.getType());
    }

    protected CharSequence _generateDefaultValue(SimpleTypeDecl t) {
        String _xblockexpression = null;
        boolean _equals = t.getName().equals("int");
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("0");
            return _builder;
        }
        boolean _equals_1 = t.getName().equals("real");
        if (_equals_1) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("0.0");
            return _builder_1;
        }
        boolean _equals_2 = t.getName().equals("bool");
        if (_equals_2) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("true");
            return _builder_2;
        }
        boolean _equals_3 = t.getName().equals("string");
        if (_equals_3) {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("\"\"");
            return _builder_3;
        }
        _xblockexpression = "";
        return _xblockexpression;
    }

    protected CharSequence _generateDefaultValue(EnumTypeDecl t) {
        CharSequence _typeToCommaSyntax = this.typeToCommaSyntax(t);
        String _plus = _typeToCommaSyntax + "::";
        String _name = ((EnumElement)t.getLiterals().get(0)).getName();
        return String.valueOf(_plus) + _name;
    }

    protected CharSequence _generateDefaultValue(RecordTypeDecl t) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _typeToCommaSyntax = this.typeToCommaSyntax(t);
        _builder.append((Object)_typeToCommaSyntax);
        _builder.append("{");
        List<RecordField> _allFields = TypeUtilities.getAllFields(t);
        boolean _hasElements = false;
        for (RecordField f : _allFields) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _name = f.getName();
            _builder.append(_name);
            _builder.append(" = ");
            CharSequence _generateDefaultValue = this.generateDefaultValue(f.getType());
            _builder.append((Object)_generateDefaultValue);
        }
        _builder.append("}");
        return _builder;
    }

    protected CharSequence _generateDefaultValue(VectorTypeDecl t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<");
        CharSequence _typeToCommaSyntax = this.typeToCommaSyntax(t);
        _builder.append((Object)_typeToCommaSyntax);
        _builder.append(">[]");
        return _builder;
    }

    protected CharSequence _generateDefaultValue(VectorTypeConstructor t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<");
        CharSequence _typeToCommaSyntax = this.typeToCommaSyntax(t);
        _builder.append((Object)_typeToCommaSyntax);
        _builder.append(">[]");
        return _builder;
    }

    protected CharSequence _generateDefaultValue(MapTypeDecl t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<");
        CharSequence _typeToCommaSyntax = this.typeToCommaSyntax(t);
        _builder.append((Object)_typeToCommaSyntax);
        _builder.append(">{}");
        return _builder;
    }

    protected CharSequence _generateDefaultValue(MapTypeConstructor t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<");
        CharSequence _typeToCommaSyntax = this.typeToCommaSyntax(t);
        _builder.append((Object)_typeToCommaSyntax);
        _builder.append(">{}");
        return _builder;
    }

    public CharSequence typeToCommaSyntax(EObject t) {
        if (t instanceof MapTypeConstructor) {
            return this._typeToCommaSyntax((MapTypeConstructor)t);
        }
        if (t instanceof TypeDecl) {
            return this._typeToCommaSyntax((TypeDecl)t);
        }
        if (t instanceof TypeReference) {
            return this._typeToCommaSyntax((TypeReference)t);
        }
        if (t instanceof VectorTypeConstructor) {
            return this._typeToCommaSyntax((VectorTypeConstructor)t);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(t).toString());
    }

    public CharSequence generateDefaultValue(EObject t) {
        if (t instanceof EnumTypeDecl) {
            return this._generateDefaultValue((EnumTypeDecl)t);
        }
        if (t instanceof MapTypeDecl) {
            return this._generateDefaultValue((MapTypeDecl)t);
        }
        if (t instanceof RecordTypeDecl) {
            return this._generateDefaultValue((RecordTypeDecl)t);
        }
        if (t instanceof SimpleTypeDecl) {
            return this._generateDefaultValue((SimpleTypeDecl)t);
        }
        if (t instanceof VectorTypeDecl) {
            return this._generateDefaultValue((VectorTypeDecl)t);
        }
        if (t instanceof MapTypeConstructor) {
            return this._generateDefaultValue((MapTypeConstructor)t);
        }
        if (t instanceof TypeReference) {
            return this._generateDefaultValue((TypeReference)t);
        }
        if (t instanceof VectorTypeConstructor) {
            return this._generateDefaultValue((VectorTypeConstructor)t);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(t).toString());
    }
}

