#
# Copyright (c) 2021 Contributors to the Eclipse Foundation
#
# This program and the accompanying materials are made
# available under the terms of the Eclipse Public License 2.0
# which is available at https://www.eclipse.org/legal/epl-2.0/
#
# SPDX-License-Identifier: EPL-2.0
#

import test_net as net
from reachability_graph import ReachabilityGraph
from verification_report import VerificationReport
import time

n = net.net()
start_rg = time.time()
rg = ReachabilityGraph(net.net(), 200, 'full')
print('Reachability graph generation took', time.time() - start_rg, 'seconds')

start_lookup = time.time()
print('Lookup computation took', time.time() - start_lookup, 'seconds')

start_vr = time.time()
vr = VerificationReport(n, rg, [['Off']])
print('Verification report genration took', time.time() - start_vr, 'seconds')

start_j = time.time()
vr.to_json()
print('Json export took', time.time() - start_vr, 'seconds')

