/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.element;

import org.eclipse.emf.common.util.URI;

public enum PictureType {
    BMP(11),
    DIB(7),
    EMF(2),
    EPS(10),
    GIF(8),
    JPG(5),
    JPEG(5),
    PICT(4),
    PNG(6),
    TIFF(9),
    WMF(3),
    WPG(12);

    private static final String DATA = "data";
    private static final String MIME_IMAGE_TYPE = "image/";
    private static final String SEMI_COLON = ";";
    private int poiType;

    private PictureType(int poiType) {
        this.poiType = poiType;
    }

    public int getPoiType() {
        return this.poiType;
    }

    public static PictureType toType(URI pictureURI) {
        String type;
        int semiColonIndex;
        PictureType res = null;
        if (pictureURI.fileExtension() != null) {
            String extension = pictureURI.fileExtension();
            try {
                res = PictureType.valueOf(extension.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else if (DATA.equalsIgnoreCase(pictureURI.scheme()) && (semiColonIndex = pictureURI.opaquePart().indexOf(SEMI_COLON)) > 0 && (type = pictureURI.opaquePart().substring(0, semiColonIndex).toLowerCase()).startsWith(MIME_IMAGE_TYPE)) {
            try {
                res = PictureType.valueOf(type.substring(MIME_IMAGE_TYPE.length()).toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (res == null) {
            res = JPG;
        }
        return res;
    }
}

