/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.ResourceCompareInput;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.part.ResourceTransfer;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class CompareWithOtherResourceDialog
extends TitleAreaDialog {
    private int MIN_WIDTH = 320;
    private int MIN_HEIGHT_WITH_ANCESTOR = 320;
    private int MIN_HEIGHT_WITHOUT_ANCESTOR = 238;
    private Button okButton;
    private InternalGroup rightPanel;
    private InternalGroup leftPanel;
    private InternalExpandable ancestorPanel;
    private ISelection selection;
    private ExternalResourcesProject tmpProject = new ExternalResourcesProject();

    protected CompareWithOtherResourceDialog(Shell shell, ISelection selection) {
        super(shell);
        this.setShellStyle(1040);
        this.selection = selection;
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        mainPanel.setLayout((Layout)new GridLayout(1, true));
        mainPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.ancestorPanel = new InternalExpandable(mainPanel);
        this.ancestorPanel.setText(CompareMessages.CompareWithOtherResourceDialog_ancestor);
        GridData ancestorGD = new GridData(4, 4, true, false);
        this.ancestorPanel.setLayoutData(ancestorGD);
        this.leftPanel = new InternalGroup(mainPanel);
        this.leftPanel.setText(CompareMessages.CompareWithOtherResourceDialog_leftPanel);
        this.leftPanel.setLayoutData(new GridData(4, 4, true, false));
        this.rightPanel = new InternalGroup(mainPanel);
        this.rightPanel.setText(CompareMessages.CompareWithOtherResourceDialog_rightPanel);
        this.rightPanel.setLayoutData(new GridData(4, 4, true, false));
        this.setSelection(this.selection);
        this.getShell().setText(CompareMessages.CompareWithOtherResourceDialog_dialogTitle);
        this.setTitle(CompareMessages.CompareWithOtherResourceDialog_dialogMessage);
        this.adjustSize(this.ancestorPanel.expandable.isExpanded());
        return mainPanel;
    }

    private void adjustSize(boolean expanded) {
        int minWidth = this.convertHorizontalDLUsToPixels(this.MIN_WIDTH);
        int minHeight = this.convertVerticalDLUsToPixels(expanded ? this.MIN_HEIGHT_WITH_ANCESTOR : this.MIN_HEIGHT_WITHOUT_ANCESTOR);
        this.getShell().setMinimumSize(minWidth, minHeight);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.okButton = this.getButton(0);
        this.updateErrorInfo();
        this.setMessage(CompareMessages.CompareWithOtherResourceDialog_info);
    }

    private void setSelection(ISelection selection) {
        IResource[] selectedResources = Utilities.getResources(selection);
        switch (selectedResources.length) {
            case 1: {
                this.leftPanel.workspaceContent.setResource(selectedResources[0]);
                break;
            }
            case 2: {
                this.leftPanel.workspaceContent.setResource(selectedResources[0]);
                this.rightPanel.workspaceContent.setResource(selectedResources[1]);
                break;
            }
            case 3: {
                this.ancestorPanel.workspaceContent.setResource(selectedResources[0]);
                this.ancestorPanel.expandable.setExpanded(true);
                this.leftPanel.workspaceContent.setResource(selectedResources[1]);
                this.rightPanel.workspaceContent.setResource(selectedResources[2]);
                break;
            }
        }
        this.setInitialContentTypes();
    }

    private void setInitialContentTypes() {
        this.ancestorPanel.setContentType(0);
        this.leftPanel.setContentType(0);
        this.rightPanel.setContentType(0);
    }

    private boolean isComparePossible() {
        Object[] resources = this.ancestorPanel.getResource() == null ? new IResource[]{this.leftPanel.getResource(), this.rightPanel.getResource()} : new IResource[]{this.ancestorPanel.getResource(), this.leftPanel.getResource(), this.rightPanel.getResource()};
        ResourceCompareInput r = new ResourceCompareInput(new CompareConfiguration());
        return r.isEnabled((ISelection)new StructuredSelection(resources));
    }

    private void updateErrorInfo() {
        if (this.okButton != null) {
            if (this.leftPanel.getResource() == null || this.rightPanel.getResource() == null) {
                this.setMessage(CompareMessages.CompareWithOtherResourceDialog_error_empty, 3);
                this.okButton.setEnabled(false);
            } else if (!this.isComparePossible()) {
                this.setMessage(CompareMessages.CompareWithOtherResourceDialog_error_not_comparable, 3);
                this.okButton.setEnabled(false);
            } else {
                this.setMessage(CompareMessages.CompareWithOtherResourceDialog_info);
                this.okButton.setEnabled(true);
            }
        }
    }

    public IResource[] getResult() {
        IResource rightResource = this.rightPanel.getResource();
        IResource leftResource = this.leftPanel.getResource();
        IResource ancestorResource = this.ancestorPanel.getResource();
        IResource[] resources = ancestorResource == null ? new IResource[]{leftResource, rightResource} : new IResource[]{ancestorResource, leftResource, rightResource};
        return resources;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionName = String.valueOf(((Object)((Object)this)).getClass().getName()) + "_dialogBounds";
        IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(CompareWithOtherResourceDialog.class)).getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    private abstract class ContentTypeElement {
        private Button radioButton;
        protected Button mainButton;
        protected Text text;
        private String type;
        protected InternalSection section;
        private IResource resource;

        public ContentTypeElement(Composite parent, String type, InternalSection section) {
            this.type = type;
            this.section = section;
            this.createContents(parent);
        }

        private void createContents(Composite parent) {
            this.createRadioButton(parent);
            this.createText(parent);
            this.createMainButton(parent);
        }

        private void createRadioButton(Composite parent) {
            this.radioButton = new Button(parent, 16);
            this.radioButton.setText(this.type);
        }

        protected void createText(Composite parent) {
            this.text = new Text(parent, 2048);
            this.text.setLayoutData((Object)new GridData(4, 4, true, true));
            this.text.setEditable(false);
        }

        protected void createMainButton(Composite parent) {
            this.mainButton = new Button(parent, 8);
            this.mainButton.setLayoutData((Object)new GridData(4, 4, false, false));
        }

        protected Button getRadioButton() {
            return this.radioButton;
        }

        protected String getText() {
            return this.text.getText();
        }

        protected void setText(String string) {
            this.text.setText(string);
        }

        protected void setEnabled(boolean enabled) {
            this.radioButton.setSelection(enabled);
            this.mainButton.setEnabled(enabled);
            this.text.setEnabled(enabled);
        }

        protected void setResource(IResource resource) {
            this.resource = resource;
            this.section.setResource(resource);
        }

        public IResource getResource() {
            return this.resource;
        }

        void clearResource() {
            this.resource = null;
            this.text.setText("");
        }
    }

    private class ExternalFileContent
    extends ContentTypeElement {
        public ExternalFileContent(Composite parent, InternalSection section) {
            super(parent, CompareMessages.CompareWithOtherResourceDialog_externalFileRadioButton, section);
        }

        @Override
        protected void createMainButton(Composite parent) {
            super.createMainButton(parent);
            this.mainButton.setText(CompareMessages.CompareWithOtherResourceDialog_externalFileMainButton);
            this.mainButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IFile r = CompareWithOtherResourceDialog.this.tmpProject.getExternalFile();
                    if (r == null) {
                        return;
                    }
                    ExternalFileContent.this.setResource((IResource)r);
                }
            });
        }

        @Override
        protected void setResource(IResource resource) {
            super.setResource(resource);
            this.text.setText(resource.getLocation().toOSString());
        }
    }

    private class ExternalFolderContent
    extends ContentTypeElement {
        public ExternalFolderContent(Composite parent, InternalSection section) {
            super(parent, CompareMessages.CompareWithOtherResourceDialog_externalFolderRadioButton, section);
        }

        @Override
        protected void createMainButton(Composite parent) {
            super.createMainButton(parent);
            this.mainButton.setText(CompareMessages.CompareWithOtherResourceDialog_externalFolderMainButton);
            this.mainButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IFolder r = CompareWithOtherResourceDialog.this.tmpProject.getExternalFolder();
                    if (r == null) {
                        return;
                    }
                    ExternalFolderContent.this.setResource((IResource)r);
                }
            });
        }

        @Override
        protected void setResource(IResource resource) {
            super.setResource(resource);
            this.text.setText(resource.getLocation().toOSString());
        }
    }

    private class ExternalResourcesProject {
        private int counter = 0;
        private static final String TMP_PROJECT_NAME = ".org.eclipse.compare.tmp";
        private static final String TMP_PROJECT_FILE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>.org.eclipse.compare.tmp\t</name>\n\t<comment></comment>\n\t<projects>\n\t</projects>\n\t<buildSpec>\n\t</buildSpec>\n\t<natures>\n\t</natures>\n</projectDescription>";
        private static final String TMP_FOLDER_NAME = "tmpFolder";

        private ExternalResourcesProject() {
        }

        private IProject createTmpProject() throws CoreException {
            IProject project = this.getTmpProject();
            if (!project.isAccessible()) {
                try {
                    IPath stateLocation = CompareUI.getPlugin().getStateLocation();
                    if (!project.exists()) {
                        IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
                        desc.setLocation(stateLocation.append(TMP_PROJECT_NAME));
                        project.create(desc, null);
                    }
                    try {
                        project.open(null);
                    }
                    catch (CoreException coreException) {
                        IPath projectPath = stateLocation.append(TMP_PROJECT_NAME);
                        projectPath.toFile().mkdirs();
                        Throwable throwable = null;
                        Object var5_7 = null;
                        try (FileOutputStream output = new FileOutputStream(projectPath.append(".project").toOSString());){
                            output.write(TMP_PROJECT_FILE.getBytes());
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        project.open(null);
                    }
                    this.getTmpFolder(project);
                }
                catch (IOException iOException) {
                    return project;
                }
                catch (CoreException ce) {
                    throw new CoreException(ce.getStatus());
                }
            }
            project.setHidden(true);
            return project;
        }

        private IFolder getTmpFolder(IProject project) throws CoreException {
            IFolder folder = project.getFolder(TMP_FOLDER_NAME);
            if (!folder.exists()) {
                folder.create(0, true, null);
            }
            return folder;
        }

        private IFile getExternalFile() {
            FileDialog dialog = new FileDialog(CompareWithOtherResourceDialog.this.getShell());
            String path = dialog.open();
            if (path != null) {
                return (IFile)this.linkResource((IPath)new Path(path));
            }
            return null;
        }

        private IFolder getExternalFolder() {
            DirectoryDialog dialog = new DirectoryDialog(CompareWithOtherResourceDialog.this.getShell());
            String path = dialog.open();
            if (path != null) {
                return (IFolder)this.linkResource((IPath)new Path(path));
            }
            return null;
        }

        private IResource linkResource(IPath path) {
            IFile r = null;
            String resourceName = path.lastSegment();
            try {
                IProject project = this.createTmpProject();
                if (!project.isOpen()) {
                    project.open(null);
                }
                if (path.toFile().isFile()) {
                    r = this.getTmpFolder(project).getFile(resourceName);
                    if (r.exists()) {
                        String extension = path.getFileExtension();
                        String fileName = path.removeFileExtension().lastSegment();
                        r = this.getTmpFolder(project).getFile(this.getName(fileName, extension));
                    }
                    r.createLink(path, 256, null);
                } else {
                    r = this.getTmpFolder(project).getFolder(resourceName);
                    if (r.exists()) {
                        r = this.getTmpFolder(project).getFolder(this.getName(resourceName, null));
                    }
                    ((IFolder)r).createLink(path, 256, null);
                }
            }
            catch (CoreException e) {
                CompareUIPlugin.log(e);
                MessageDialog.openError((Shell)CompareWithOtherResourceDialog.this.getShell(), (String)CompareMessages.CompareWithOtherResourceDialog_externalFile_errorTitle, (String)CompareMessages.CompareWithOtherResourceDialog_externalFile_errorMessage);
            }
            return r;
        }

        private String getName(String name, String extension) {
            if (this.counter != 0) {
                name = String.valueOf(name) + "-" + this.counter;
            }
            this.counter = (this.counter + 1) % 3;
            if (extension != null) {
                name = String.valueOf(name) + "." + extension;
            }
            return name;
        }

        private IProject getTmpProject() {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(TMP_PROJECT_NAME);
        }
    }

    private class FileTextDragListener
    implements DragSourceListener {
        private ContentTypeElement element;

        public FileTextDragListener(ContentTypeElement element) {
            this.element = element;
        }

        public void dragFinished(DragSourceEvent event) {
            this.element.setText("");
        }

        public void dragSetData(DragSourceEvent event) {
            event.data = this.element.getText();
        }

        public void dragStart(DragSourceEvent event) {
            if (this.element.getText() == null) {
                event.doit = false;
            }
        }
    }

    private class FileTextDropListener
    implements DropTargetListener {
        private ContentTypeElement element;
        private ResourceTransfer resourceTransfer;
        private TextTransfer textTransfer;

        public FileTextDropListener(ContentTypeElement element) {
            this.element = element;
            this.resourceTransfer = ResourceTransfer.getInstance();
            this.textTransfer = TextTransfer.getInstance();
        }

        public void dragEnter(DropTargetEvent event) {
            if (event.detail == 16) {
                event.detail = (event.operations & 1) != 0 ? 1 : 0;
            }
            TransferData[] transferDataArray = event.dataTypes;
            int n = event.dataTypes.length;
            int n2 = 0;
            while (n2 < n) {
                TransferData dataType = transferDataArray[n2];
                if (this.resourceTransfer.isSupportedType(dataType) || this.textTransfer.isSupportedType(dataType)) {
                    event.currentDataType = dataType;
                    if (event.detail == 1) break;
                    event.detail = 0;
                    break;
                }
                ++n2;
            }
        }

        public void dragLeave(DropTargetEvent event) {
        }

        public void dragOperationChanged(DropTargetEvent event) {
            if (event.detail == 16) {
                event.detail = (event.operations & 1) != 0 ? 1 : 0;
            } else if (this.resourceTransfer.isSupportedType(event.currentDataType) && event.detail != 1) {
                event.detail = 0;
            }
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            IResource[] files;
            if (this.textTransfer.isSupportedType(event.currentDataType)) {
                String txt = (String)event.data;
                IResource r = ResourcesPlugin.getWorkspace().getRoot().findMember(txt);
                if (r != null) {
                    this.element.setResource(r);
                }
            } else if (this.resourceTransfer.isSupportedType(event.currentDataType) && (files = (IResource[])event.data).length > 0) {
                this.element.setResource(files[0]);
            }
        }

        public void dropAccept(DropTargetEvent event) {
        }
    }

    private class InternalExpandable
    extends InternalSection {
        private ExpandableComposite expandable;

        public InternalExpandable(Composite parent) {
            this.createContents(parent);
        }

        @Override
        protected void createContents(Composite parent) {
            final Composite p = parent;
            this.expandable = new ExpandableComposite(parent, 0, 6);
            super.createContents((Composite)this.expandable);
            this.createClearButton((Composite)this.group);
            this.expandable.setClient((Control)this.group);
            this.expandable.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    p.layout();
                    CompareWithOtherResourceDialog.this.adjustSize(e.getState());
                }
            });
        }

        private void createClearButton(Composite parent) {
            Button clearButton = new Button(parent, 8);
            clearButton.setText(CompareMessages.CompareWithOtherResourceDialog_clear);
            clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InternalExpandable.this.clearResource();
                }
            });
        }

        public void setText(String text) {
            this.expandable.setText(text);
            this.group.setText(text);
        }

        public void setLayoutData(GridData layoutData) {
            this.expandable.setLayoutData((Object)layoutData);
        }
    }

    private class InternalGroup
    extends InternalSection {
        public InternalGroup(Composite parent) {
            this.createContents(parent);
        }

        public void setText(String text) {
            this.group.setText(text);
        }

        public void setLayoutData(GridData layoutData) {
            this.group.setLayoutData((Object)layoutData);
        }
    }

    private abstract class InternalSection {
        public static final int WORKSPACE = 0;
        public static final int EXTERNAL_FILE = 1;
        public static final int EXTERNAL_FOLDER = 2;
        protected Group group;
        private IResource resource;
        ExternalFileContent externalFileContent;
        ExternalFolderContent externalFolderContent;
        WorkspaceContent workspaceContent;

        private InternalSection() {
        }

        protected void createContents(Composite parent) {
            this.group = new Group(parent, 0);
            this.group.setLayout((Layout)new GridLayout(3, false));
            this.group.setLayoutData((Object)new GridData(4, 4, true, false));
            this.workspaceContent = new WorkspaceContent((Composite)this.group, this);
            this.externalFileContent = new ExternalFileContent((Composite)this.group, this);
            this.externalFolderContent = new ExternalFolderContent((Composite)this.group, this);
            this.addListenersToRadioButtons();
        }

        private void addListenersToRadioButtons() {
            ContentTypeElement[] elements;
            ContentTypeElement[] contentTypeElementArray = elements = new ContentTypeElement[]{this.workspaceContent, this.externalFileContent, this.externalFolderContent};
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                ContentTypeElement e = contentTypeElementArray[n2];
                e.getRadioButton().addListener(13, event -> {
                    ContentTypeElement[] contentTypeElementArray2 = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ContentTypeElement element = contentTypeElementArray2[n2];
                        if (event.widget != element.getRadioButton()) {
                            element.setEnabled(false);
                        } else {
                            element.setEnabled(true);
                            this.setResource(element.getResource());
                        }
                        ++n2;
                    }
                });
                ++n2;
            }
        }

        protected IResource getResource() {
            return this.resource;
        }

        protected void setResource(IResource resource) {
            this.resource = resource;
            CompareWithOtherResourceDialog.this.updateErrorInfo();
        }

        protected void setResource(String s) {
            IResource tmp = ResourcesPlugin.getWorkspace().getRoot().findMember(s);
            this.resource = tmp instanceof IWorkspaceRoot ? null : tmp;
            CompareWithOtherResourceDialog.this.updateErrorInfo();
        }

        protected void clearResource() {
            this.resource = null;
            this.workspaceContent.clearResource();
            this.externalFileContent.clearResource();
            this.externalFolderContent.clearResource();
            CompareWithOtherResourceDialog.this.updateErrorInfo();
        }

        protected void setContentType(int type) {
            switch (type) {
                case 0: {
                    this.workspaceContent.setEnabled(true);
                    this.externalFileContent.setEnabled(false);
                    this.externalFolderContent.setEnabled(false);
                    break;
                }
                case 1: {
                    this.workspaceContent.setEnabled(false);
                    this.externalFileContent.setEnabled(true);
                    this.externalFolderContent.setEnabled(false);
                    break;
                }
                case 2: {
                    this.workspaceContent.setEnabled(false);
                    this.externalFileContent.setEnabled(false);
                    this.externalFolderContent.setEnabled(true);
                    break;
                }
            }
        }
    }

    private class WorkspaceContent
    extends ContentTypeElement {
        public WorkspaceContent(Composite parent, InternalSection section) {
            super(parent, CompareMessages.CompareWithOtherResourceDialog_workspaceRadioButton, section);
        }

        @Override
        protected void createMainButton(Composite parent) {
            super.createMainButton(parent);
            this.mainButton.setText(CompareMessages.CompareWithOtherResourceDialog_workspaceMainButton);
            this.mainButton.setVisible(false);
        }

        @Override
        protected void createText(Composite parent) {
            super.createText(parent);
            this.text.setEditable(true);
            this.text.addModifyListener(e -> {
                this.section.setResource(this.text.getText());
                CompareWithOtherResourceDialog.this.updateErrorInfo();
            });
            this.text.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    WorkspaceContent.this.section.setResource(WorkspaceContent.this.text.getText());
                    CompareWithOtherResourceDialog.this.updateErrorInfo();
                }
            });
            this.initDrag();
            this.initDrop();
        }

        @Override
        protected void setResource(IResource resource) {
            super.setResource(resource);
            this.text.setText(resource.getFullPath().toOSString());
        }

        protected void initDrag() {
            DragSource source = new DragSource((Control)this.text, 19);
            source.setTransfer(new Transfer[]{TextTransfer.getInstance(), ResourceTransfer.getInstance()});
            source.addDragListener((DragSourceListener)new FileTextDragListener(this));
        }

        protected void initDrop() {
            DropTarget target = new DropTarget((Control)this.text, 19);
            target.setTransfer(new Transfer[]{TextTransfer.getInstance(), ResourceTransfer.getInstance()});
            target.addDropListener((DropTargetListener)new FileTextDropListener(this));
        }
    }
}

