/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.factory.stack.primitive.MutableBooleanStackFactory;
import org.eclipse.collections.api.stack.primitive.MutableBooleanStack;
import org.eclipse.collections.impl.stack.mutable.primitive.BooleanArrayStack;

public enum MutableBooleanStackFactoryImpl implements MutableBooleanStackFactory
{
    INSTANCE;


    @Override
    public MutableBooleanStack empty() {
        return new BooleanArrayStack();
    }

    @Override
    public MutableBooleanStack of() {
        return this.empty();
    }

    @Override
    public MutableBooleanStack with() {
        return this.empty();
    }

    @Override
    public MutableBooleanStack of(boolean ... items) {
        return this.with(items);
    }

    @Override
    public MutableBooleanStack with(boolean ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return BooleanArrayStack.newStackWith(items);
    }

    @Override
    public MutableBooleanStack ofAll(BooleanIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableBooleanStack withAll(BooleanIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return BooleanArrayStack.newStack(items);
    }

    @Override
    public MutableBooleanStack ofAllReversed(BooleanIterable items) {
        return this.withAllReversed(items);
    }

    @Override
    public MutableBooleanStack withAllReversed(BooleanIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return BooleanArrayStack.newStackFromTopToBottom(items);
    }
}

