/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.collector;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.DoubleSummaryStatistics;
import java.util.IntSummaryStatistics;
import java.util.LongSummaryStatistics;
import java.util.stream.Collector;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.impl.collector.SerializableDoubleSummaryStatistics;
import org.eclipse.collections.impl.collector.SerializableIntSummaryStatistics;
import org.eclipse.collections.impl.collector.SerializableLongSummaryStatistics;
import org.eclipse.collections.impl.factory.Maps;

@Deprecated
public class SummaryStatistics<T>
implements Procedure<T>,
Externalizable {
    private static final long serialVersionUID = 1L;
    private ImmutableMap<Object, IntFunction<? super T>> intFunctionsMap = Maps.immutable.empty();
    private ImmutableMap<Object, LongFunction<? super T>> longFunctionsMap = Maps.immutable.empty();
    private ImmutableMap<Object, DoubleFunction<? super T>> doubleFunctionsMap = Maps.immutable.empty();
    private ImmutableMap<Object, SerializableIntSummaryStatistics> intStatisticsMap = Maps.immutable.empty();
    private ImmutableMap<Object, SerializableLongSummaryStatistics> longStatisticsMap = Maps.immutable.empty();
    private ImmutableMap<Object, SerializableDoubleSummaryStatistics> doubleStatisticsMap = Maps.immutable.empty();

    public SummaryStatistics() {
    }

    private SummaryStatistics(ImmutableMap<Object, IntFunction<? super T>> intFunctions, ImmutableMap<Object, LongFunction<? super T>> longFunctions, ImmutableMap<Object, DoubleFunction<? super T>> doubleFunctions) {
        this.intFunctionsMap = intFunctions;
        this.intStatisticsMap = intFunctions.collectValues((key, value) -> new SerializableIntSummaryStatistics());
        this.longFunctionsMap = longFunctions;
        this.longStatisticsMap = longFunctions.collectValues((key, value) -> new SerializableLongSummaryStatistics());
        this.doubleFunctionsMap = doubleFunctions;
        this.doubleStatisticsMap = doubleFunctions.collectValues((key, value) -> new SerializableDoubleSummaryStatistics());
    }

    public SummaryStatistics<T> addIntFunction(Object key, IntFunction<? super T> function) {
        this.intFunctionsMap = this.intFunctionsMap.newWithKeyValue(key, (Object)function);
        this.intStatisticsMap = this.intStatisticsMap.newWithKeyValue(key, (Object)new SerializableIntSummaryStatistics());
        return this;
    }

    public SummaryStatistics<T> addLongFunction(Object key, LongFunction<? super T> function) {
        this.longFunctionsMap = this.longFunctionsMap.newWithKeyValue(key, (Object)function);
        this.longStatisticsMap = this.longStatisticsMap.newWithKeyValue(key, (Object)new SerializableLongSummaryStatistics());
        return this;
    }

    public SummaryStatistics<T> addDoubleFunction(Object key, DoubleFunction<? super T> function) {
        this.doubleFunctionsMap = this.doubleFunctionsMap.newWithKeyValue(key, (Object)function);
        this.doubleStatisticsMap = this.doubleStatisticsMap.newWithKeyValue(key, (Object)new SerializableDoubleSummaryStatistics());
        return this;
    }

    @Override
    public void value(T each) {
        this.intStatisticsMap.forEachKeyValue((key, value) -> value.accept(((IntFunction)this.intFunctionsMap.get(key)).intValueOf(each)));
        this.longStatisticsMap.forEachKeyValue((key, value) -> value.accept(((LongFunction)this.longFunctionsMap.get(key)).longValueOf(each)));
        this.doubleStatisticsMap.forEachKeyValue((key, value) -> value.accept(((DoubleFunction)this.doubleFunctionsMap.get(key)).doubleValueOf(each)));
    }

    public DoubleSummaryStatistics getDoubleStats(Object name) {
        return (DoubleSummaryStatistics)this.doubleStatisticsMap.get(name);
    }

    public IntSummaryStatistics getIntStats(Object name) {
        return (IntSummaryStatistics)this.intStatisticsMap.get(name);
    }

    public LongSummaryStatistics getLongStats(Object name) {
        return (LongSummaryStatistics)this.longStatisticsMap.get(name);
    }

    public SummaryStatistics<T> merge(SummaryStatistics<T> summaryStatistics) {
        this.doubleStatisticsMap.forEachKeyValue((key, value) -> value.combine(summaryStatistics.getDoubleStats(key)));
        this.intStatisticsMap.forEachKeyValue((key, value) -> value.combine(summaryStatistics.getIntStats(key)));
        this.longStatisticsMap.forEachKeyValue((key, value) -> value.combine(summaryStatistics.getLongStats(key)));
        return this;
    }

    public Collector<T, ?, SummaryStatistics<T>> toCollector() {
        return Collector.of(() -> new SummaryStatistics<T>(this.intFunctionsMap, this.longFunctionsMap, this.doubleFunctionsMap), SummaryStatistics::value, SummaryStatistics::merge, Collector.Characteristics.UNORDERED);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.intFunctionsMap);
        out.writeObject(this.longFunctionsMap);
        out.writeObject(this.doubleFunctionsMap);
        out.writeObject(this.intStatisticsMap);
        out.writeObject(this.longStatisticsMap);
        out.writeObject(this.doubleStatisticsMap);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.intFunctionsMap = (ImmutableMap)in.readObject();
        this.longFunctionsMap = (ImmutableMap)in.readObject();
        this.doubleFunctionsMap = (ImmutableMap)in.readObject();
        this.intStatisticsMap = (ImmutableMap)in.readObject();
        this.longStatisticsMap = (ImmutableMap)in.readObject();
        this.doubleStatisticsMap = (ImmutableMap)in.readObject();
    }
}

