/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.factory.map.primitive.ImmutableDoubleIntMapFactory;
import org.eclipse.collections.api.map.primitive.DoubleIntMap;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleIntMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleIntEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleIntHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleIntSingletonMap;

public enum ImmutableDoubleIntMapFactoryImpl implements ImmutableDoubleIntMapFactory
{
    INSTANCE;


    @Override
    public ImmutableDoubleIntMap empty() {
        return ImmutableDoubleIntEmptyMap.INSTANCE;
    }

    @Override
    public ImmutableDoubleIntMap of() {
        return this.empty();
    }

    @Override
    public ImmutableDoubleIntMap with() {
        return this.empty();
    }

    @Override
    public ImmutableDoubleIntMap of(double key, int value) {
        return this.with(key, value);
    }

    @Override
    public ImmutableDoubleIntMap with(double key, int value) {
        return new ImmutableDoubleIntSingletonMap(key, value);
    }

    @Override
    public ImmutableDoubleIntMap ofAll(DoubleIntMap map) {
        return this.withAll(map);
    }

    @Override
    public ImmutableDoubleIntMap withAll(DoubleIntMap map) {
        if (map instanceof ImmutableDoubleIntMap) {
            return (ImmutableDoubleIntMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            double key = map.keysView().doubleIterator().next();
            return new ImmutableDoubleIntSingletonMap(key, map.get(key));
        }
        return new ImmutableDoubleIntHashMap(map);
    }
}

