/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.AbstractDataModificator;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.ITransformation;
import org.eclipse.chemclipse.model.statistics.ISample;
import org.eclipse.chemclipse.model.statistics.ISampleData;
import org.eclipse.chemclipse.model.statistics.ISamples;
import org.eclipse.chemclipse.model.statistics.IVariable;

public class TransformationLOG10
extends AbstractDataModificator
implements ITransformation {
    @Override
    public String getDescription() {
        return "Decadic Logarithm Transformation";
    }

    @Override
    public String getName() {
        return "Decadic Logarithm Transformation";
    }

    @Override
    public <V extends IVariable, S extends ISample> void process(ISamples<V, S> samples) {
        samples.getSampleList().stream().filter(s -> s.isSelected() || !this.isOnlySelected()).forEach(s -> {
            List sampleData = s.getSampleData();
            int i = 0;
            while (i < sampleData.size()) {
                if (!this.skipVariable(samples, i)) {
                    ISampleData data = (ISampleData)sampleData.get(i);
                    data.setModifiedData(10.0 * Math.log10(this.getData(data)));
                }
                ++i;
            }
        });
    }
}

