/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.cli;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.core.BatchProcess;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.io.JobReader;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.model.BatchProcessJob;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.chemclipse.rcp.app.cli.AbstractCommandLineProcessor;
import org.eclipse.chemclipse.rcp.app.cli.ICommandLineProcessor;
import org.eclipse.chemclipse.xxd.process.support.ProcessTypeSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class Processor
extends AbstractCommandLineProcessor
implements ICommandLineProcessor {
    private static final Logger logger = Logger.getLogger(Processor.class);

    public void process(String[] args) {
        JobReader reader = new JobReader();
        String filePath = args[0].trim();
        File file = new File(filePath);
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            logger.info((Object)"Read batch process");
            BatchProcessJob batchProcessJob = reader.read(file, (IProgressMonitor)monitor);
            logger.info((Object)"Execute batch process");
            BatchProcess bp = new BatchProcess(new DataType[]{DataType.CSD, DataType.MSD, DataType.WSD}, (ProcessSupplierContext)new ProcessTypeSupport());
            bp.execute(batchProcessJob, (IProgressMonitor)monitor);
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e);
        }
        catch (FileIsNotReadableException e) {
            logger.warn((Object)e);
        }
        catch (FileIsEmptyException e) {
            logger.warn((Object)e);
        }
        catch (IOException e) {
            logger.warn((Object)e);
        }
    }
}

