/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.core;

import org.eclipse.chemclipse.chromatogram.msd.identifier.library.AbstractLibraryService;
import org.eclipse.chemclipse.chromatogram.msd.identifier.library.ILibraryService;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.internal.identifier.FileIdentifier;
import org.eclipse.chemclipse.model.exceptions.ValueMustNotBeNullException;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class LibraryService
extends AbstractLibraryService
implements ILibraryService {
    private final FileIdentifier fileIdentifier = new FileIdentifier();

    public IProcessingInfo<IMassSpectra> identify(IIdentificationTarget identificationTarget, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        try {
            monitor.subTask("File Identifier - get reference mass spectrum");
            this.validateIdentificationTarget(identificationTarget);
            IMassSpectra massSpectra = this.fileIdentifier.getMassSpectra(identificationTarget, monitor);
            processingInfo.setProcessingResult((Object)massSpectra);
        }
        catch (ValueMustNotBeNullException e) {
            processingInfo.addErrorMessage("File Identifier", "The identification target is not available.");
        }
        return processingInfo;
    }

    public boolean accepts(IIdentificationTarget identificationTarget) {
        return this.fileIdentifier.isValid(identificationTarget);
    }

    public boolean requireProgressMonitor() {
        return !this.fileIdentifier.getDatabasesCache().isLoaded();
    }
}

