/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.xpass.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.xpass.settings.CutOffScanFilterSettings;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.filter.IScanFilter;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.comparator.IonAbundanceComparator;
import org.eclipse.chemclipse.processing.core.DefaultProcessingResult;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.IProcessingResult;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.chemclipse.processing.filter.Filter;
import org.eclipse.chemclipse.processing.filter.FilterList;
import org.eclipse.chemclipse.support.comparator.SortOrder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IScanFilter.class, Filter.class})
public class CutOffScanFilter
implements IScanFilter<CutOffScanFilterSettings> {
    public String getName() {
        return "Ion cut off";
    }

    public String getDescription() {
        return "Cut off the lowest/highest abundance ions";
    }

    public CutOffScanFilterSettings createNewConfiguration() {
        return new CutOffScanFilterSettings();
    }

    public IProcessingResult<Boolean> filterIScans(FilterList<IScan> filterItems, CutOffScanFilterSettings configuration, IProgressMonitor monitor) throws IllegalArgumentException {
        if (configuration == null) {
            configuration = this.createNewConfiguration();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)filterItems.size());
        DefaultProcessingResult result = new DefaultProcessingResult();
        int modified = 0;
        for (IScan scan : filterItems) {
            if (scan instanceof IScanMSD) {
                IScanMSD scanMSD = (IScanMSD)scan;
                if (this.processScan(scanMSD, configuration)) {
                    scanMSD.setDirty(true);
                    ++modified;
                }
                subMonitor.worked(1);
                continue;
            }
            throw new IllegalArgumentException("Input contains invalid scan, use IScanFilter#acceptsIScan(IScan) to check for compatible types");
        }
        result.setProcessingResult((Object)(modified > 0 ? Boolean.TRUE : Boolean.FALSE));
        result.addMessage((IProcessingMessage)new ProcessingMessage(MessageType.INFO, this.getName(), MessageFormat.format("{0} scan(s) where processed", modified)));
        return result;
    }

    private boolean processScan(IScanMSD massSpectrum, CutOffScanFilterSettings configuration) {
        boolean removed = false;
        ArrayList ions = new ArrayList(massSpectrum.getIons());
        Collections.sort(ions, new IonAbundanceComparator(configuration.getCutDirection() == CutOffScanFilterSettings.CutDirection.HIGH ? SortOrder.DESC : SortOrder.ASC));
        int counter = 0;
        for (IIon ion : ions) {
            if (counter >= configuration.getCutNumber()) {
                massSpectrum.removeIon(ion);
                removed = true;
            }
            ++counter;
        }
        return removed;
    }

    public boolean acceptsIScan(IScan item) {
        return item instanceof IScanMSD;
    }
}

