/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.internal.core;

import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;

public abstract class AbstractPeakQuantitationCalculator {
    public boolean doQuantify(IPeak peakToQuantify, String nameOfStandard) {
        boolean doQuantify = false;
        List quantitationReferences = peakToQuantify.getQuantitationReferences();
        if (quantitationReferences.size() == 0 || quantitationReferences.contains(nameOfStandard)) {
            doQuantify = true;
        }
        return doQuantify;
    }

    public boolean isIdentifierMatch(IPeak peak, String nameOfQuantitationCompound) {
        Set targets = peak.getTargets();
        for (IIdentificationTarget target : targets) {
            if (!target.getLibraryInformation().getName().equals(nameOfQuantitationCompound)) continue;
            return true;
        }
        return false;
    }

    public boolean isAreaValid(IPeak peakToQuantify, IPeak peakISTD) {
        double peakAreaQuantify = peakToQuantify.getIntegratedArea();
        double peakAreaISTD = peakISTD.getIntegratedArea();
        return peakAreaQuantify > 0.0 && peakAreaISTD > 0.0;
    }
}

