/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.internal.calculator;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.internal.calculator.IQuantitationCalculatorMSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.implementation.QuantitationEntry;
import org.eclipse.chemclipse.model.quantitation.CalibrationMethod;
import org.eclipse.chemclipse.model.quantitation.IQuantitationCompound;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.model.quantitation.IQuantitationSignals;
import org.eclipse.chemclipse.model.quantitation.IResponseSignals;
import org.eclipse.chemclipse.model.quantitation.QuantitationSupport;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.exceptions.EvaluationException;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;
import org.eclipse.chemclipse.numeric.equations.QuadraticEquation;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.chemclipse.support.text.ValueFormat;

public class QuantitationCalculatorMSD
implements IQuantitationCalculatorMSD {
    private static final Logger logger = Logger.getLogger(QuantitationCalculatorMSD.class);

    @Override
    public List<IQuantitationEntry> calculateQuantitationResults(IPeak peak, Set<IQuantitationCompound> quantitationCompounds, IProcessingInfo processingInfo) {
        ArrayList<IQuantitationEntry> quantitationEntries = new ArrayList<IQuantitationEntry>();
        for (IQuantitationCompound quantitationCompound : quantitationCompounds) {
            try {
                List<IQuantitationEntry> quantitationEntriesPeak = this.calculateQuantitationResults(peak, quantitationCompound);
                quantitationEntries.addAll(quantitationEntriesPeak);
            }
            catch (Exception e) {
                processingInfo.addMessage((IProcessingMessage)new ProcessingMessage(MessageType.WARN, "ChemClipse Quantitation", "Something has gone wrong to quantify the peak: " + peak + " using the quantitation compound: " + quantitationCompound));
                logger.warn((Object)e);
            }
        }
        return quantitationEntries;
    }

    @Override
    public List<IQuantitationEntry> calculateQuantitationResults(IPeak peak, IQuantitationCompound quantitationCompound) throws EvaluationException {
        if (peak == null || quantitationCompound == null) {
            throw new EvaluationException("Peak and QuantitationCompound must be not null.");
        }
        if (peak.getIntegratedArea() <= 0.0) {
            logger.warn((Object)("Quantitation - peak area is 0: " + peak));
            throw new EvaluationException("The peak area must be greater than 0.");
        }
        QuantitationSupport integrationQuantitationSupport = new QuantitationSupport(peak);
        if (quantitationCompound.isUseTIC()) {
            if (integrationQuantitationSupport.validateTIC()) {
                return this.getQuantitationEntriesTIC(quantitationCompound, peak);
            }
            throw new EvaluationException("The peak integration entries (m/z - abundance) do not match with the quantitation TIC ion. See log file.");
        }
        IQuantitationSignals quantitationSignals = quantitationCompound.getQuantitationSignals();
        List selectedQuantitationIons = quantitationSignals.getSelectedSignals();
        if (integrationQuantitationSupport.validateXIC(selectedQuantitationIons)) {
            if (peak instanceof IPeakMSD) {
                IPeakMSD peakMSD = (IPeakMSD)peak;
                return this.getQuantitationEntriesXIC(quantitationCompound, peakMSD, selectedQuantitationIons, integrationQuantitationSupport);
            }
            throw new EvaluationException("The peak is not of type peakMSD.");
        }
        throw new EvaluationException("The peak integration entries (m/z - abundance) do not match with the quantitation XIC ions. See log file.");
    }

    private List<IQuantitationEntry> getQuantitationEntriesTIC(IQuantitationCompound quantitationCompound, IPeak peak) {
        ArrayList<IQuantitationEntry> quantitationEntries = new ArrayList<IQuantitationEntry>();
        double integratedArea = peak.getIntegratedArea();
        double signal = 0.0;
        IQuantitationEntry quantitationEntry = this.getQuantitationEntry(signal, quantitationCompound, integratedArea);
        quantitationEntries.add(quantitationEntry);
        return quantitationEntries;
    }

    private List<IQuantitationEntry> getQuantitationEntriesXIC(IQuantitationCompound quantitationCompound, IPeakMSD peak, List<Double> selectedQuantitationIons, QuantitationSupport integrationQuantitationSupport) {
        ArrayList<IQuantitationEntry> quantitationEntries = new ArrayList<IQuantitationEntry>();
        IPeakMassSpectrum massSpectrum = peak.getExtractedMassSpectrum();
        IExtractedIonSignal extractedIonSignal = massSpectrum.getExtractedIonSignal();
        float totalSignalMassSpectrum = extractedIonSignal.getTotalSignal();
        for (double ion : selectedQuantitationIons) {
            IQuantitationEntry quantitationEntry;
            double integratedArea = integrationQuantitationSupport.getIntegrationArea(ion);
            float abundance = extractedIonSignal.getAbundance((int)ion);
            if (integrationQuantitationSupport.isTotalSignalIntegrated()) {
                float percentageIonAbundance = (float)(1.0 / (double)totalSignalMassSpectrum * (double)abundance);
                quantitationEntry = this.getQuantitationEntry(ion, quantitationCompound, integratedArea * (double)percentageIonAbundance);
            } else {
                quantitationEntry = this.getQuantitationEntry(ion, quantitationCompound, integratedArea);
            }
            quantitationEntries.add(quantitationEntry);
        }
        return quantitationEntries;
    }

    private IQuantitationEntry getQuantitationEntry(double signal, IQuantitationCompound quantitationCompound, double integratedArea) {
        String name = quantitationCompound.getName();
        String chemicalClass = quantitationCompound.getChemicalClass();
        String concentrationUnit = quantitationCompound.getConcentrationUnit();
        boolean isCrossZero = quantitationCompound.isCrossZero();
        double concentration = 0.0;
        String description = "";
        CalibrationMethod calibrationMethod = quantitationCompound.getCalibrationMethod();
        IResponseSignals responseSignals = quantitationCompound.getResponseSignals();
        double minResponse = responseSignals.getMinResponseValue(signal);
        double maxResponse = responseSignals.getMaxResponseValue(signal);
        switch (calibrationMethod) {
            case LINEAR: {
                LinearEquation linearEquation = responseSignals.getLinearEquation(signal, isCrossZero);
                concentration = linearEquation.calculateX(integratedArea);
                if (integratedArea < minResponse) {
                    description = this.getDescriptionResponse(integratedArea, minResponse, "< min");
                    break;
                }
                if (!(integratedArea > maxResponse)) break;
                description = this.getDescriptionResponse(integratedArea, maxResponse, "> max");
                break;
            }
            case QUADRATIC: {
                double delta2;
                double factorAverage = quantitationCompound.getResponseSignals().getAverageFactor(signal, isCrossZero);
                double concentrationAverage = factorAverage * integratedArea;
                QuadraticEquation quadraticEquation = responseSignals.getQuadraticEquation(signal, isCrossZero);
                if (integratedArea < minResponse) {
                    description = this.getDescriptionResponse(integratedArea, minResponse, "< min");
                    break;
                }
                if (integratedArea > maxResponse) {
                    description = this.getDescriptionResponse(integratedArea, maxResponse, "> max");
                    break;
                }
                double concentration1 = quadraticEquation.calculateX(integratedArea, true);
                double concentration2 = quadraticEquation.calculateX(integratedArea, false);
                double delta1 = Math.abs(concentration1 - concentrationAverage);
                concentration = delta1 < (delta2 = Math.abs(concentration2 - concentrationAverage)) ? concentration1 : concentration2;
                break;
            }
            case AVERAGE: {
                double factor = responseSignals.getAverageFactor(signal, isCrossZero);
                concentration = factor * integratedArea;
                break;
            }
            case ISTD: {
                break;
            }
        }
        QuantitationEntry quantitationEntry = new QuantitationEntry(name, concentration, concentrationUnit, integratedArea);
        quantitationEntry.setSignal(signal);
        quantitationEntry.setCalibrationMethod(calibrationMethod.toString());
        quantitationEntry.setUsedCrossZero(isCrossZero);
        quantitationEntry.setChemicalClass(chemicalClass);
        quantitationEntry.setDescription(description);
        return quantitationEntry;
    }

    private String getDescriptionResponse(double integratedArea, double response, String definition) {
        DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.0E0");
        StringBuilder builder = new StringBuilder();
        builder.append("The integrated area '");
        builder.append(decimalFormat.format(integratedArea));
        builder.append("' is ");
        builder.append(definition);
        builder.append(" response '");
        builder.append(decimalFormat.format(response));
        builder.append("'.");
        return builder.toString();
    }
}

