/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.wizards;

import org.eclipse.chemclipse.msd.model.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SubtractScanPage
extends WizardPage {
    private final IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();

    public SubtractScanPage() {
        super(SubtractScanPage.class.getName());
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.createLabel(composite);
        this.createButtonNominalMZ(composite);
        this.createButtonNormalize(composite);
        this.createButtonMultiSubtract(composite);
        this.createButtonShowDialog(composite);
        this.setControl((Control)composite);
    }

    private Label createLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setText("Select a scan in the chromatogram. It will be subtracted from the current selection.");
        return label;
    }

    private Button createButtonNominalMZ(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setLayoutData((Object)new GridData(768));
        button.setText("Nominal m/z");
        button.setToolTipText("Select to use nomimal m/z.");
        button.setSelection(PreferenceSupplier.isUseNominalMZ());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useNominalMZ = button.getSelection();
                PreferenceSupplier.setUseNominalMZ((boolean)useNominalMZ);
            }
        });
        return button;
    }

    private Button createButtonNormalize(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setLayoutData((Object)new GridData(768));
        button.setText("Normalize Intensities");
        button.setToolTipText("Select to use normalize the intensities.");
        button.setSelection(PreferenceSupplier.isUseNormalizedScan());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useNormalizedScan = button.getSelection();
                PreferenceSupplier.setUseNormalizedScan((boolean)useNormalizedScan);
            }
        });
        return button;
    }

    private Button createButtonMultiSubtract(Composite parent) {
        final Image imageSubtractOne = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/subtractScanOne.png", "128x68");
        final Image imageSubtractMany = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/subtractScanMany.png", "128x68");
        boolean isSubtractMany = this.preferenceStore.getBoolean("enableMultiSubtract");
        final String textSubtractOne = "Modus: One Scan Subtract";
        final String textSubtractMany = "Modus: Multi Scan Subtract";
        final Button button = new Button(parent, 32);
        button.setLayoutData((Object)new GridData(768));
        button.setText(isSubtractMany ? textSubtractMany : textSubtractOne);
        button.setToolTipText("Select whether to subtract one or many scans.");
        button.setImage(isSubtractMany ? imageSubtractMany : imageSubtractOne);
        button.setSelection(isSubtractMany);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSubtractMany = button.getSelection();
                SubtractScanPage.this.preferenceStore.setValue("enableMultiSubtract", isSubtractMany);
                button.setText(isSubtractMany ? textSubtractMany : textSubtractOne);
                button.setImage(isSubtractMany ? imageSubtractMany : imageSubtractOne);
            }
        });
        return button;
    }

    private Button createButtonShowDialog(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setLayoutData((Object)new GridData(131072, 1024, true, true));
        button.setText("Show this dialog");
        button.setSelection(this.preferenceStore.getBoolean("showSubtractDialog"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SubtractScanPage.this.preferenceStore.setValue("showSubtractDialog", button.getSelection());
            }
        });
        return button;
    }
}

