/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.converter.ISupplierFileIdentifier;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.SupplierEditorSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.UserPathPreferencePage;
import org.eclipse.chemclipse.xxd.process.files.SupplierFileIdentifierCache;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;

public class InputWizardSettings {
    public static final int DEFAULT_WIDTH = 500;
    public static final int DEFAULT_HEIGHT = 400;
    private String title = "Title";
    private String description = "Description";
    private IPreferenceStore preferenceStore;
    private String userLocationPreferenceKey;
    private SupplierFileIdentifierCache identifierCache;

    public InputWizardSettings(IPreferenceStore preferenceStore, String userLocationPreferenceKey, Collection<? extends ISupplierFileIdentifier> supplierFileIdentifierList) {
        this.preferenceStore = preferenceStore;
        this.userLocationPreferenceKey = userLocationPreferenceKey;
        this.identifierCache = new SupplierFileIdentifierCache(500);
        this.identifierCache.setIdentifier(supplierFileIdentifierList);
    }

    public IPreferencePage getPreferencePage() {
        return new UserPathPreferencePage(this.getPreferenceStore(), this.getUserLocationPreferenceKey());
    }

    public IPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public String getUserLocationPreferenceKey() {
        return this.userLocationPreferenceKey;
    }

    public SupplierFileIdentifierCache getSupplierCache() {
        return this.identifierCache;
    }

    public String getTitle() {
        return this.title == null ? "" : this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static InputWizardSettings create(IPreferenceStore preferenceStore, DataType ... dataTypes) {
        return InputWizardSettings.create(preferenceStore, null, dataTypes);
    }

    public static InputWizardSettings create(IPreferenceStore preferenceStore, String userLocationPreferenceKey, DataType ... dataTypes) {
        ArrayList<SupplierEditorSupport> list = new ArrayList<SupplierEditorSupport>();
        DataType[] dataTypeArray = dataTypes;
        int n = dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            DataType dataType = dataTypeArray[n2];
            list.add(new SupplierEditorSupport(dataType));
            ++n2;
        }
        return new InputWizardSettings(preferenceStore, userLocationPreferenceKey, list);
    }
}

