/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors;

import java.util.List;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChromatogramDataSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors.ExtendedChromatogramUI;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.events.AbstractHandledEventProcessor;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;

public class PeakSelectionHandler
extends AbstractHandledEventProcessor
implements IHandledEventProcessor {
    private ExtendedChromatogramUI extendedChromatogramUI;
    private IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    private ChromatogramDataSupport chromatogramDataSupport = new ChromatogramDataSupport();

    public PeakSelectionHandler(ExtendedChromatogramUI extendedChromatogramUI) {
        this.extendedChromatogramUI = extendedChromatogramUI;
    }

    public int getEvent() {
        return 1;
    }

    public int getButton() {
        return 1;
    }

    public int getStateMask() {
        return 65536;
    }

    public void handleEvent(BaseChart baseChart, Event event) {
        IPeak peak;
        int stopRetentiontime;
        int retentionTimeDelta;
        int retentionTime;
        int startRetentionTime;
        IChromatogram chromatogram;
        List peaks;
        IChromatogramSelection chromatogramSelection = this.extendedChromatogramUI.getChromatogramSelection();
        if (chromatogramSelection != null && (peaks = (chromatogram = chromatogramSelection.getChromatogram()).getPeaks(startRetentionTime = (retentionTime = (int)baseChart.getSelectedPrimaryAxisValue(event.x, "X_AXIS")) - (retentionTimeDelta = this.preferenceStore.getInt("deltaMillisecondsPeakSelection")), stopRetentiontime = retentionTime + retentionTimeDelta)) != null && peaks.size() > 0 && (peak = this.selectNearestPeak(peaks, retentionTime)) != null) {
            chromatogramSelection.setSelectedPeak(peak);
            boolean moveRetentionTimeOnPeakSelection = this.preferenceStore.getBoolean("moveRetentionTimeOnPeakSelection");
            if (moveRetentionTimeOnPeakSelection) {
                ChromatogramDataSupport.adjustChromatogramSelection(peak, chromatogramSelection);
            }
            this.extendedChromatogramUI.updateSelection();
            IEventBroker eventBroker = ModelSupportAddon.getEventBroker();
            eventBroker.send("peak/xxd/update/selection", (Object)peak);
        }
    }

    private IPeak selectNearestPeak(List<IPeak> peaks, int retentionTime) {
        IPeak nearestPeak = null;
        for (IPeak peak : peaks) {
            if (nearestPeak == null) {
                nearestPeak = peak;
                continue;
            }
            int deltaNearest = Math.abs(retentionTime - nearestPeak.getPeakModel().getRetentionTimeAtPeakMaximum());
            int deltaCurrent = Math.abs(retentionTime - peak.getPeakModel().getRetentionTimeAtPeakMaximum());
            if (deltaCurrent > deltaNearest) continue;
            nearestPeak = peak;
        }
        return nearestPeak;
    }
}

