/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.handler.IModificationHandler;
import org.eclipse.chemclipse.model.handler.ISaveHandler;
import org.eclipse.chemclipse.model.quantitation.IQuantitationCompound;
import org.eclipse.chemclipse.model.quantitation.IQuantitationDatabase;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.support.ui.events.IKeyEventProcessor;
import org.eclipse.chemclipse.support.ui.menu.ITableMenuEntry;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.support.ui.swt.ITableSettings;
import org.eclipse.chemclipse.swt.ui.components.ISearchListener;
import org.eclipse.chemclipse.swt.ui.components.SearchSupportUI;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation.QuantitationCompoundValidator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageQuantitation;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageQuantitationAxes;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.QuantCompoundListUI;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ExtendedQuantCompoundListUI {
    private static final Logger logger = Logger.getLogger(ExtendedQuantCompoundListUI.class);
    private static final String DESCRIPTION = "Quantitation Database";
    private static final String MENU_CATEGORY = "Compounds";
    private Composite toolbarInfo;
    private Label labelInfo;
    private Composite toolbarModify;
    private Composite toolbarHeader;
    private Text textOperator;
    private Text textDescription;
    private Label labelInputErrors;
    private Text textSignal;
    private Button buttonAdd;
    private Button buttonDelete;
    private Button buttonSave;
    private Composite toolbarSearch;
    private SearchSupportUI searchSupportUI;
    private QuantCompoundListUI quantCompoundListUI;
    private QuantitationCompoundValidator validator = new QuantitationCompoundValidator();
    private ControlDecoration controlDecoration;
    private IQuantitationDatabase quantitationDatabase = null;
    private IModificationHandler modificationHandler = null;
    private ISaveHandler saveHandler = null;

    public ExtendedQuantCompoundListUI(Composite parent) {
        this.initialize(parent);
    }

    public void setModificationHandler(IModificationHandler modificationHandler) {
        this.modificationHandler = modificationHandler;
    }

    public void setSaveHandler(ISaveHandler saveHandler) {
        this.saveHandler = saveHandler;
    }

    public void update(IQuantitationDatabase quantitationDatabase) {
        this.quantitationDatabase = quantitationDatabase;
        this.quantCompoundListUI.setQuantitationDatabase(quantitationDatabase);
        this.updateInput();
        this.updateWidgets();
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.toolbarInfo = this.createToolbarInfo(parent);
        this.toolbarHeader = this.createToolbarHeader(parent);
        this.toolbarModify = this.createToolbarModify(parent);
        this.toolbarSearch = this.createToolbarSearch(parent);
        this.quantCompoundListUI = this.createTable(parent);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfo, (boolean)true);
        PartSupport.setCompositeVisibility((Composite)this.toolbarHeader, (boolean)false);
        PartSupport.setCompositeVisibility((Composite)this.toolbarModify, (boolean)false);
        PartSupport.setCompositeVisibility((Composite)this.toolbarSearch, (boolean)false);
        this.quantCompoundListUI.setEditEnabled(false);
        this.clearLabelInputErrors();
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(9, false));
        this.createButtonToggleToolbarInfo(composite);
        this.createButtonToggleToolbarHeader(composite);
        this.createButtonToggleToolbarModify(composite);
        this.createResponseTableButton(composite);
        this.createButtonToggleEditModus(composite);
        this.createButtonToggleToolbarSearch(composite);
        this.buttonSave = this.createSaveButton(composite);
        this.createResetButton(composite);
        this.createSettingsButton(composite);
    }

    private Button createButtonToggleToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the info toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedQuantCompoundListUI.this.toolbarInfo);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarHeader(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the header toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/headerdata.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedQuantCompoundListUI.this.toolbarHeader);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/headerdata.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/headerdata.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarModify(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle modify toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedQuantCompoundListUI.this.toolbarModify);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editActive.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private void createResponseTableButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Create Response Table(s)");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/calculate.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExtendedQuantCompoundListUI.this.quantitationDatabase != null) {
                    IStructuredSelection structuredSelection = ExtendedQuantCompoundListUI.this.quantCompoundListUI.getStructuredSelection();
                    if (!structuredSelection.isEmpty()) {
                        if (MessageDialog.openQuestion((Shell)e.display.getActiveShell(), (String)ExtendedQuantCompoundListUI.DESCRIPTION, (String)"Would you like to create new concentration response and signal tables for the selected entries?")) {
                            for (Object object : structuredSelection) {
                                if (!(object instanceof IQuantitationCompound)) continue;
                                IQuantitationCompound quantitationCompound = (IQuantitationCompound)object;
                                if (quantitationCompound.getQuantitationPeaks().size() > 0) {
                                    quantitationCompound.calculateSignalTablesFromPeaks();
                                    continue;
                                }
                                logger.warn((Object)("There are no quantitation peaks stored: " + quantitationCompound));
                            }
                            ExtendedQuantCompoundListUI.this.setDirty(true);
                        }
                    } else {
                        MessageDialog.openInformation((Shell)e.display.getActiveShell(), (String)ExtendedQuantCompoundListUI.DESCRIPTION, (String)"Please select at least one quantitation compound from the list.");
                    }
                }
            }
        });
    }

    private Composite createToolbarInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelInfo = new Label(composite, 0);
        this.labelInfo.setText("");
        this.labelInfo.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Composite createToolbarHeader(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.textOperator = this.createOperatorSection(composite);
        this.textDescription = this.createDescriptionSection(composite);
        return composite;
    }

    private Text createOperatorSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Operator:");
        final Text text = new Text(parent, 2048);
        text.setText("");
        text.setToolTipText("Operator");
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ExtendedQuantCompoundListUI.this.quantitationDatabase != null) {
                    ExtendedQuantCompoundListUI.this.quantitationDatabase.setOperator(text.getText().trim());
                    ExtendedQuantCompoundListUI.this.setDirty(true);
                }
            }
        });
        return text;
    }

    private Text createDescriptionSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Description:");
        final Text text = new Text(parent, 2048);
        text.setText("");
        text.setToolTipText("Description");
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ExtendedQuantCompoundListUI.this.quantitationDatabase != null) {
                    ExtendedQuantCompoundListUI.this.quantitationDatabase.setDescription(text.getText().trim());
                    ExtendedQuantCompoundListUI.this.setDirty(true);
                }
            }
        });
        return text;
    }

    private Composite createToolbarModify(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        int columns = 3;
        composite.setLayout((Layout)new GridLayout(columns, false));
        this.labelInputErrors = this.createLabel(composite, columns);
        this.textSignal = this.createTextSignal(composite);
        this.buttonAdd = this.createButtonAdd(composite);
        this.buttonDelete = this.createButtonDelete(composite);
        return composite;
    }

    private Label createLabel(Composite parent, int horizontalSpan) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = horizontalSpan;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private Text createTextSignal(Composite parent) {
        final Text text = new Text(parent, 2048);
        text.setText("");
        text.setToolTipText("Type in a new compound.");
        text.setLayoutData((Object)new GridData(768));
        this.controlDecoration = new ControlDecoration((Control)text, 16512);
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ExtendedQuantCompoundListUI.this.validate(ExtendedQuantCompoundListUI.this.validator, ExtendedQuantCompoundListUI.this.controlDecoration, text);
                if (e.keyCode == 10 || e.keyCode == 13 || e.keyCode == 0x1000050) {
                    ExtendedQuantCompoundListUI.this.addCompound(e.display.getActiveShell());
                }
            }
        });
        return text;
    }

    private Button createButtonAdd(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Add a new compound.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedQuantCompoundListUI.this.addCompound(e.display.getActiveShell());
            }
        });
        return button;
    }

    private Button createButtonDelete(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Delete the selected compound(s).");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/delete.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedQuantCompoundListUI.this.deleteCompounds(e.display.getActiveShell());
            }
        });
        return button;
    }

    private Composite createToolbarSearch(Composite parent) {
        this.searchSupportUI = new SearchSupportUI(parent, 0);
        this.searchSupportUI.setLayoutData((Object)new GridData(768));
        this.searchSupportUI.setSearchListener(new ISearchListener(){

            public void performSearch(String searchText, boolean caseSensitive) {
                ExtendedQuantCompoundListUI.this.quantCompoundListUI.setSearchText(searchText, caseSensitive);
            }
        });
        return this.searchSupportUI;
    }

    private Button createButtonToggleEditModus(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Enable/disable to edit the table.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editEntryDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean editEnabled = !ExtendedQuantCompoundListUI.this.quantCompoundListUI.isEditEnabled();
                ExtendedQuantCompoundListUI.this.quantCompoundListUI.setEditEnabled(editEnabled);
                button.setImage(ApplicationImageFactory.getInstance().getImage(editEnabled ? "org.eclipse.chemclipse.rcp.ui.icons/editEntryActive.gif" : "org.eclipse.chemclipse.rcp.ui.icons/editEntryDefault.gif", "16x16"));
                ExtendedQuantCompoundListUI.this.updateInput();
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarSearch(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle search toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedQuantCompoundListUI.this.toolbarSearch);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createSaveButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Save");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/save.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExtendedQuantCompoundListUI.this.saveHandler != null) {
                    ExtendedQuantCompoundListUI.this.saveHandler.doSave();
                }
            }
        });
        return button;
    }

    private void createResetButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Reset");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedQuantCompoundListUI.this.reset();
            }
        });
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)new PreferencePageQuantitation()));
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("2", (IPreferencePage)new PreferencePageQuantitationAxes()));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedQuantCompoundListUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the settings.");
                    }
                }
            }
        });
    }

    private void deleteCompounds(Shell shell) {
        MessageBox messageBox = new MessageBox(shell, 196);
        messageBox.setText("Delete Compound(s)");
        messageBox.setMessage("Would you like to delete the selected compound(s)?");
        if (messageBox.open() == 64) {
            for (Object object : this.quantCompoundListUI.getStructuredSelection()) {
                if (!(object instanceof IQuantitationCompound)) continue;
                this.quantitationDatabase.remove((Object)((IQuantitationCompound)object));
            }
            this.updateInput();
        }
    }

    private void addCompound(Shell shell) {
        boolean isInputValid = this.validate(this.validator, this.controlDecoration, this.textSignal);
        if (isInputValid) {
            this.setCompound(shell, this.validator);
        } else {
            MessageDialog.openError((Shell)shell, (String)"Quantitation Compound", (String)"The given signal is invalid.");
        }
    }

    private void setCompound(Shell shell, QuantitationCompoundValidator validator) {
        IQuantitationCompound quantitationCompound;
        if (this.quantitationDatabase != null && (quantitationCompound = validator.getQuantitationCompound(true)) != null) {
            if (this.quantitationDatabase.containsQuantitationCompund(quantitationCompound.getName())) {
                MessageDialog.openError((Shell)shell, (String)"Quantitation Compound", (String)"The compound already exists.");
            } else {
                this.quantitationDatabase.add((Object)quantitationCompound);
                this.textSignal.setText("");
                this.updateInput();
            }
        }
    }

    private void applySettings() {
        this.searchSupportUI.reset();
    }

    private void reset() {
        this.searchSupportUI.reset();
    }

    private QuantCompoundListUI createTable(final Composite parent) {
        final QuantCompoundListUI listUI = new QuantCompoundListUI(parent, 268503810);
        Table table = listUI.getTable();
        table.setLayoutData((Object)new GridData(1808));
        listUI.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object object = listUI.getStructuredSelection().getFirstElement();
                if (object instanceof IQuantitationCompound) {
                    final IQuantitationCompound quantitationCompound = (IQuantitationCompound)object;
                    final IEventBroker eventBroker = ModelSupportAddon.getEventBroker();
                    parent.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            eventBroker.send("quantitation/database/compound/update", (Object)quantitationCompound);
                        }
                    });
                }
            }
        });
        Shell shell = listUI.getTable().getShell();
        ITableSettings tableSettings = listUI.getTableSettings();
        this.addDeleteMenuEntry(shell, tableSettings);
        this.addKeyEventProcessors(shell, tableSettings);
        listUI.applySettings(tableSettings);
        return listUI;
    }

    private void addDeleteMenuEntry(final Shell shell, ITableSettings tableSettings) {
        tableSettings.addMenuEntry(new ITableMenuEntry(){

            public String getName() {
                return "Delete Compound(s)";
            }

            public String getCategory() {
                return ExtendedQuantCompoundListUI.MENU_CATEGORY;
            }

            public void execute(ExtendedTableViewer extendedTableViewer) {
                ExtendedQuantCompoundListUI.this.deleteCompounds(shell);
            }
        });
    }

    private void addKeyEventProcessors(final Shell shell, ITableSettings tableSettings) {
        tableSettings.addKeyEventProcessor(new IKeyEventProcessor(){

            public void handleEvent(ExtendedTableViewer extendedTableViewer, KeyEvent e) {
                if (e.keyCode == 127) {
                    ExtendedQuantCompoundListUI.this.deleteCompounds(shell);
                }
            }
        });
    }

    private void updateInput() {
        if (this.quantitationDatabase != null) {
            String editInformation = this.quantCompoundListUI.isEditEnabled() ? "(Edit is enabled)" : "(Edit is disabled)";
            this.labelInfo.setText("Quantitation Database " + editInformation);
            this.textOperator.setText(this.quantitationDatabase.getOperator());
            this.textDescription.setText(this.quantitationDatabase.getDescription());
            this.quantCompoundListUI.setInput(this.quantitationDatabase);
        } else {
            this.labelInfo.setText("");
            this.textOperator.setText("");
            this.textDescription.setText("");
            this.quantCompoundListUI.clear();
        }
    }

    private boolean validate(IValidator validator, ControlDecoration controlDecoration, Text text) {
        IStatus status = validator.validate((Object)text.getText());
        if (status.isOK()) {
            controlDecoration.hide();
            this.clearLabelInputErrors();
            return true;
        }
        this.setLabelInputError(status.getMessage());
        controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        controlDecoration.showHoverText("Input Error");
        controlDecoration.show();
        return false;
    }

    private void clearLabelInputErrors() {
        this.labelInputErrors.setText("Example: Styrene | mg/kg | 5.68");
        this.labelInputErrors.setBackground(null);
    }

    private void setLabelInputError(String message) {
        this.labelInputErrors.setText(message);
        this.labelInputErrors.setBackground(Colors.YELLOW);
    }

    private void updateWidgets() {
        this.buttonSave.setEnabled(this.saveHandler != null);
        boolean enabled = this.quantitationDatabase != null;
        this.textSignal.setEnabled(enabled);
        this.buttonAdd.setEnabled(enabled);
        this.buttonDelete.setEnabled(enabled);
    }

    private void setDirty(boolean dirty) {
        if (this.modificationHandler != null) {
            this.modificationHandler.setDirty(dirty);
        }
    }
}

