/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.updates.IChromatogramSelectionUpdateListener;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.runnables.ChromatogramLengthModifier;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.EditorUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChromatogramDataSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ChromatogramSourceCombo;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class ChromatogramAlignmentUI
extends Composite
implements IChromatogramSelectionUpdateListener {
    private static final Logger logger = Logger.getLogger(ChromatogramAlignmentUI.class);
    private static final String MODIFY_LENGTH_SHORTEST = "MODIFY_LENGTH_SHORTEST";
    private static final String MODIFY_LENGTH_SELECTED = "MODIFY_LENGTH_SELECTED";
    private static final String MODIFY_LENGTH_LONGEST = "MODIFY_LENGTH_LONGEST";
    private static final String MODIFY_LENGTH_ADJUST = "MODIFY_LENGTH_ADJUST";
    private ChromatogramSourceCombo chromatogramSourceCombo;
    private List<Button> buttons = new ArrayList<Button>();
    private IChromatogramSelection chromatogramSelectionSource;
    private ChromatogramDataSupport chromatogramDataSupport = new ChromatogramDataSupport();
    private EditorUpdateSupport editorUpdateSupport = new EditorUpdateSupport();
    private IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();

    public ChromatogramAlignmentUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void update(IChromatogramSelection chromatogramSelectionSource) {
        this.chromatogramSelectionSource = chromatogramSelectionSource;
        this.enableButtons();
    }

    private void createControl() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        composite.setBackground(Colors.WHITE);
        GridLayout gridLayout = new GridLayout(8, false);
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        composite.setLayout((Layout)gridLayout);
        this.chromatogramSourceCombo = this.createChromatogramSourceCombo(composite);
        this.createVerticalSeparator(composite);
        this.buttons.add(this.createButtonShrinkChromatograms(composite));
        this.buttons.add(this.createButtonAlignChromatograms(composite));
        this.buttons.add(this.createButtonStretchChromatograms(composite));
        this.buttons.add(this.createButtonAdjustChromatograms(composite));
        this.createVerticalSeparator(composite);
        this.buttons.add(this.createButtonSetRanges(composite));
    }

    private ChromatogramSourceCombo createChromatogramSourceCombo(Composite parent) {
        ChromatogramSourceCombo chromatogramSourceCombo = new ChromatogramSourceCombo(parent, 0);
        chromatogramSourceCombo.setLayoutData(new GridData(768));
        Combo combo = chromatogramSourceCombo.getCombo();
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChromatogramAlignmentUI.this.enableButtons();
            }
        });
        return chromatogramSourceCombo;
    }

    private Button createButtonShrinkChromatograms(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Shrink the chromatograms to the smallest chromatogram of all open editors.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/shrinkChromatograms.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChromatogramAlignmentUI.this.modifyChromatogramLength(e.display.getActiveShell(), ChromatogramAlignmentUI.MODIFY_LENGTH_SHORTEST);
            }
        });
        return button;
    }

    private Button createButtonAlignChromatograms(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Align the chromatograms to the length of the selection.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/alignChromatograms.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChromatogramAlignmentUI.this.modifyChromatogramLength(e.display.getActiveShell(), ChromatogramAlignmentUI.MODIFY_LENGTH_SELECTED);
            }
        });
        return button;
    }

    private Button createButtonStretchChromatograms(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Stretch the chromatograms to the widest chromatogram of all open editors.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/stretchChromatograms.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChromatogramAlignmentUI.this.modifyChromatogramLength(e.display.getActiveShell(), ChromatogramAlignmentUI.MODIFY_LENGTH_LONGEST);
            }
        });
        return button;
    }

    private Button createButtonAdjustChromatograms(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Adjust the chromatograms using the settings");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/adjustChromatograms.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChromatogramAlignmentUI.this.modifyChromatogramLength(e.display.getActiveShell(), ChromatogramAlignmentUI.MODIFY_LENGTH_ADJUST);
            }
        });
        return button;
    }

    private Button createButtonSetRanges(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Set the time range for all editors.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/execute_add.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ChromatogramAlignmentUI.this.setRanges()) {
                    MessageDialog.openInformation((Shell)e.display.getActiveShell(), (String)"Range Selection", (String)"The selected editor range has been set successfully to all opened chromatograms.");
                }
            }
        });
        return button;
    }

    private void enableButtons() {
        boolean enabled = this.chromatogramSelectionSource != null && (this.chromatogramSourceCombo.isSourceReferences() || this.chromatogramSourceCombo.isSourceEditors());
        for (Button button : this.buttons) {
            button.setEnabled(enabled);
        }
    }

    private void createVerticalSeparator(Composite parent) {
        Label label = new Label(parent, 514);
        GridData gridData = new GridData();
        gridData.heightHint = 35;
        label.setLayoutData((Object)gridData);
    }

    private boolean setRanges() {
        if (this.chromatogramSelectionSource != null) {
            int startRetentionTime = this.chromatogramSelectionSource.getStartRetentionTime();
            int stopRetentionTime = this.chromatogramSelectionSource.getStopRetentionTime();
            float startAbundance = this.chromatogramSelectionSource.getStartAbundance();
            float stopAbundance = this.chromatogramSelectionSource.getStopAbundance();
            boolean setChromatogramIntensityRange = this.preferenceStore.getBoolean("setChromatogramIntensityRange");
            for (IChromatogramSelection selection : this.getTargetChromatogramSelections()) {
                if (selection == this.chromatogramSelectionSource) continue;
                selection.setStartRetentionTime(startRetentionTime);
                selection.setStopRetentionTime(stopRetentionTime);
                if (!setChromatogramIntensityRange) continue;
                selection.setStartAbundance(startAbundance);
                selection.setStopAbundance(stopAbundance);
            }
            return true;
        }
        return false;
    }

    private void modifyChromatogramLength(Shell shell, String modifyLengthType) {
        IChromatogram chromatogram;
        MessageBox messageBox = new MessageBox(shell, 196);
        messageBox.setText("Modify Chromatogram Length");
        messageBox.setMessage("Would you like to modify the length of all opened chromatograms? Peaks will be deleted.");
        if (messageBox.open() == 64 && (chromatogram = this.getChromatogram(modifyLengthType)) != null) {
            int chromatogramLength;
            int scanDelay;
            if (MODIFY_LENGTH_ADJUST.equals(modifyLengthType)) {
                scanDelay = this.preferenceStore.getInt("stretchChromatogramMillisecondsScanDelay");
                chromatogramLength = this.preferenceStore.getInt("stretchChromatogramMillisecondsLength");
            } else {
                scanDelay = chromatogram.getScanDelay();
                chromatogramLength = chromatogram.getStopRetentionTime();
                this.preferenceStore.setValue("stretchChromatogramMillisecondsScanDelay", scanDelay);
                this.preferenceStore.setValue("stretchChromatogramMillisecondsLength", chromatogramLength);
            }
            for (IChromatogramSelection chromatogramSelection : this.getTargetChromatogramSelections()) {
                if (this.realignChromatogram(modifyLengthType, chromatogramSelection, chromatogram)) {
                    ChromatogramLengthModifier runnable = new ChromatogramLengthModifier(chromatogramSelection, scanDelay, chromatogramLength);
                    ProgressMonitorDialog monitor = new ProgressMonitorDialog(shell);
                    try {
                        monitor.run(true, true, (IRunnableWithProgress)runnable);
                    }
                    catch (InvocationTargetException e) {
                        logger.warn((Object)e);
                    }
                    catch (InterruptedException e) {
                        logger.warn((Object)e);
                    }
                }
                if (MODIFY_LENGTH_SELECTED.equals(modifyLengthType)) continue;
                this.update();
            }
        }
    }

    private boolean realignChromatogram(String modifyLengthType, IChromatogramSelection chromatogramSelection, IChromatogram chromatogram) {
        if (MODIFY_LENGTH_ADJUST.equals(modifyLengthType)) {
            return true;
        }
        return chromatogramSelection.getChromatogram() != chromatogram;
    }

    private IChromatogram getChromatogram(String modifyLengthType) {
        IChromatogram chromatogram;
        switch (modifyLengthType) {
            case "MODIFY_LENGTH_SHORTEST": {
                chromatogram = this.getShortestChromatogram();
                break;
            }
            case "MODIFY_LENGTH_ADJUST": 
            case "MODIFY_LENGTH_SELECTED": {
                if (this.chromatogramSelectionSource != null) {
                    chromatogram = this.chromatogramSelectionSource.getChromatogram();
                    break;
                }
                chromatogram = null;
                break;
            }
            case "MODIFY_LENGTH_LONGEST": {
                chromatogram = this.getLongestChromatogram();
                break;
            }
            default: {
                chromatogram = null;
            }
        }
        return chromatogram;
    }

    private IChromatogram getShortestChromatogram() {
        IChromatogram chromatogram = null;
        int maxRetentionTime = Integer.MAX_VALUE;
        for (IChromatogramSelection chromatogramSelection : this.getTargetChromatogramSelections()) {
            if (chromatogramSelection.getChromatogram().getStopRetentionTime() >= maxRetentionTime) continue;
            maxRetentionTime = chromatogramSelection.getChromatogram().getStopRetentionTime();
            chromatogram = chromatogramSelection.getChromatogram();
        }
        return chromatogram;
    }

    private IChromatogram getLongestChromatogram() {
        IChromatogram chromatogram = null;
        int minRetentionTime = Integer.MIN_VALUE;
        for (IChromatogramSelection chromatogramSelection : this.getTargetChromatogramSelections()) {
            if (chromatogramSelection.getChromatogram().getStopRetentionTime() <= minRetentionTime) continue;
            minRetentionTime = chromatogramSelection.getChromatogram().getStopRetentionTime();
            chromatogram = chromatogramSelection.getChromatogram();
        }
        return chromatogram;
    }

    private List<IChromatogramSelection> getTargetChromatogramSelections() {
        ArrayList<IChromatogramSelection> selections = new ArrayList<IChromatogramSelection>();
        if (this.chromatogramSelectionSource != null) {
            if (this.chromatogramSourceCombo.isSourceReferences()) {
                selections.add(this.chromatogramSelectionSource);
                List referencedChromatograms = this.chromatogramSelectionSource.getChromatogram().getReferencedChromatograms();
                for (IChromatogram referencedChromatogram : referencedChromatograms) {
                    IChromatogramSelection<?, ?> chromatogramSelectionSink = this.chromatogramDataSupport.getChromatogramSelection(referencedChromatogram);
                    selections.add(chromatogramSelectionSink);
                }
            } else if (this.chromatogramSourceCombo.isSourceEditors()) {
                selections.addAll(this.editorUpdateSupport.getChromatogramSelections());
            }
        }
        return selections;
    }
}

