/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class ProxyTableLabelProvider
implements ITableLabelProvider,
IAdaptable,
ITableColorProvider,
ITableFontProvider {
    private ITableLabelProvider proxy;
    private Set<ILabelProviderListener> listeners = new LinkedHashSet<ILabelProviderListener>();

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
        this.proxy = null;
    }

    public boolean isLabelProperty(Object element, String property) {
        if (this.proxy != null) {
            return this.proxy.isLabelProperty(element, property);
        }
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (this.proxy != null) {
            return this.proxy.getColumnImage(element, columnIndex);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (this.proxy != null) {
            return this.proxy.getColumnText(element, columnIndex);
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        if (this.proxy instanceof ITableColorProvider) {
            return ((ITableColorProvider)this.proxy).getForeground(element, columnIndex);
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        if (this.proxy instanceof ITableColorProvider) {
            return ((ITableColorProvider)this.proxy).getBackground(element, columnIndex);
        }
        return null;
    }

    public Font getFont(Object element, int columnIndex) {
        if (this.proxy instanceof ITableFontProvider) {
            return ((ITableFontProvider)this.proxy).getFont(element, columnIndex);
        }
        return null;
    }

    public void setProxy(ITableLabelProvider proxy) {
        this.proxy = proxy;
        LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this);
        for (ILabelProviderListener listener : this.listeners) {
            listener.labelProviderChanged(event);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)Adapters.adapt((Object)this.proxy, adapter);
    }
}

