/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.Collection;
import javax.inject.Inject;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.pcr.model.core.IChannel;
import org.eclipse.chemclipse.pcr.model.core.IWell;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePagePCR;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExtendedWellChannelsUI {
    private Label labelInfo;
    private Composite toolbarInfo;
    private Combo comboChannels;
    private Text textId;
    private Text textDetectionName;
    private Text textName;
    private Text textTime;
    private Text textTemperature;
    private Text textCrossingPoint;
    private IWell well = null;

    @Inject
    public ExtendedWellChannelsUI(Composite parent) {
        this.initialize(parent);
    }

    public void update(IWell well) {
        this.well = well;
        this.updateWidgets();
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.toolbarInfo = this.createToolbarInfo(parent);
        this.comboChannels = this.createComboChannels(parent);
        this.createChannelDataSection(parent);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfo, (boolean)true);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createButtonToggleToolbarInfo(composite);
        this.createResetButton(composite);
        this.createSettingsButton(composite);
    }

    private Button createButtonToggleToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle info toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedWellChannelsUI.this.toolbarInfo);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private void createResetButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Reset the Table");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedWellChannelsUI.this.updateWidgets();
            }
        });
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePagePCR preferencePage = new PreferencePagePCR();
                preferencePage.setTitle("PCR");
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)preferencePage));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedWellChannelsUI.this.updateWidgets();
                    }
                    catch (Exception e1) {
                        System.out.println(e1);
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the chart settings.");
                    }
                }
            }
        });
    }

    private Composite createToolbarInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelInfo = new Label(composite, 0);
        this.labelInfo.setText("");
        this.labelInfo.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Combo createComboChannels(Composite parent) {
        Combo combo = new Combo(parent, 8);
        combo.setLayoutData((Object)new GridData(768));
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedWellChannelsUI.this.updateChannelData();
            }
        });
        return combo;
    }

    private void createChannelDataSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.createLabel(composite, "ID:");
        this.textId = this.createText(composite);
        this.createLabel(composite, "Detection Name:");
        this.textDetectionName = this.createText(composite);
        this.createLabel(composite, "Name:");
        this.textName = this.createText(composite);
        this.createLabel(composite, "Time:");
        this.textTime = this.createText(composite);
        this.createLabel(composite, "Temperature:");
        this.textTemperature = this.createText(composite);
        this.createLabel(composite, "Crossing Point:");
        this.textCrossingPoint = this.createText(composite);
    }

    private void createLabel(Composite parent, String content) {
        Label label = new Label(parent, 0);
        label.setText(content);
    }

    private Text createText(Composite parent) {
        Text text = new Text(parent, 2056);
        text.setText("");
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private void updateWidgets() {
        this.updateChannelCombo();
        this.updateLabel();
        this.updateChannelData();
    }

    private void updateChannelData() {
        IChannel channel;
        int index;
        this.textId.setText("");
        this.textDetectionName.setText("");
        this.textName.setText("");
        this.textTime.setText("");
        this.textTemperature.setText("");
        this.textCrossingPoint.setText("");
        if (this.well != null && (index = this.comboChannels.getSelectionIndex()) >= 0 && (channel = (IChannel)this.well.getChannels().get(index)) != null) {
            this.textId.setText(Integer.toString(channel.getId()));
            this.textDetectionName.setText(channel.getDetectionName());
            this.textName.setText(channel.getName());
            this.textTime.setText(Integer.toString(channel.getTime()));
            this.textTemperature.setText(Double.toString(channel.getTemperature()));
            IPoint crossingPoint = channel.getCrossingPoint();
            if (crossingPoint != null) {
                this.textCrossingPoint.setText(Double.toString(crossingPoint.getX()));
            }
        }
    }

    private void updateChannelCombo() {
        if (this.well != null) {
            if (this.well.isEmptyMeasurement()) {
                this.comboChannels.setItems(new String[0]);
            } else {
                this.comboChannels.setItems(this.getComboItems(this.well));
                IChannel channel = this.well.getActiveChannel();
                if (channel != null) {
                    String name = channel.getDetectionName();
                    String[] items = this.comboChannels.getItems();
                    int i = 0;
                    while (i < items.length) {
                        if (items[i].equals(name)) {
                            this.comboChannels.select(i);
                            break;
                        }
                        ++i;
                    }
                } else {
                    this.comboChannels.select(0);
                }
            }
        } else {
            this.comboChannels.setItems(new String[]{""});
        }
    }

    private void updateLabel() {
        if (this.well != null) {
            this.labelInfo.setText(this.well.getLabel());
        } else {
            this.labelInfo.setText("");
        }
    }

    private String[] getComboItems(IWell well) {
        if (well != null) {
            Collection channels = well.getChannels().values();
            String[] items = new String[channels.size()];
            int i = 0;
            for (IChannel channel : channels) {
                items[i++] = channel.getDetectionName();
            }
            return items;
        }
        return new String[0];
    }
}

