/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractLabelProvider;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePagePeakTraces;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageScans;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.PeakDataSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.PeakTracesUI;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.extensions.core.IChartSettings;

public class ExtendedPeakTracesUI {
    private Composite toolbarInfo;
    private Label labelPeak;
    private ComboViewer comboViewerTraces;
    private Button buttonDeleteTrace;
    private Button checkboxActive;
    private PeakTracesUI peakTracesUI;
    private IPeak peak = null;
    private final PeakDataSupport peakDataSupport = new PeakDataSupport();

    @Inject
    public ExtendedPeakTracesUI(Composite parent) {
        this.initialize(parent);
    }

    @Focus
    public void setFocus() {
        this.update(this.peak);
    }

    public void update(IPeak peak) {
        this.peak = peak;
        this.labelPeak.setText(this.peakDataSupport.getPeakLabel(peak));
        this.checkboxActive.setSelection(peak != null ? peak.isActiveForAnalysis() : false);
        this.updatePeak();
    }

    private void updatePeak() {
        this.peakTracesUI.setInput(this.peak);
        this.updateComboTraces();
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.toolbarInfo = this.createToolbarInfo(parent);
        this.createPeakChart(parent);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfo, (boolean)true);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(8, false));
        this.createButtonToggleToolbarInfo(composite);
        this.comboViewerTraces = this.createComboViewerTraces(composite);
        this.buttonDeleteTrace = this.createButtonDeleteTrace(composite);
        this.checkboxActive = this.createActiveAnalysisButton(composite);
        this.createButtonCopyTracesClipboard(composite);
        this.createToggleChartSeriesLegendButton(composite);
        this.createResetButton(composite);
        this.createSettingsButton(composite);
    }

    private Composite createToolbarInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelPeak = new Label(composite, 0);
        this.labelPeak.setText("");
        this.labelPeak.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Button createButtonToggleToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle info toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedPeakTracesUI.this.toolbarInfo);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private ComboViewer createComboViewerTraces(Composite parent) {
        final ComboViewer comboViewer = new ComboViewer(parent, 8);
        Combo combo = comboViewer.getCombo();
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Integer) {
                    return "Trace " + Integer.toString((Integer)element);
                }
                return null;
            }
        });
        combo.setToolTipText("Select a trace.");
        combo.setLayoutData((Object)new GridData(768));
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = comboViewer.getStructuredSelection().getFirstElement();
                if (object instanceof Integer) {
                    int selectedTrace = (Integer)object;
                    ExtendedPeakTracesUI.this.buttonDeleteTrace.setEnabled(true);
                    ExtendedPeakTracesUI.this.peakTracesUI.setSelectedTrace(selectedTrace);
                    ExtendedPeakTracesUI.this.peakTracesUI.updateChart();
                }
            }
        });
        return comboViewer;
    }

    private Button createButtonDeleteTrace(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Delete the selected trace.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/delete.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = ExtendedPeakTracesUI.this.comboViewerTraces.getStructuredSelection().getFirstElement();
                if (object instanceof Integer) {
                    int selectedTrace = (Integer)object;
                    if (ExtendedPeakTracesUI.this.peak instanceof IPeakMSD) {
                        IPeakMSD peakMSD = (IPeakMSD)ExtendedPeakTracesUI.this.peak;
                        IPeakMassSpectrum scanMSD = peakMSD.getPeakModel().getPeakMassSpectrum();
                        scanMSD.removeIon(selectedTrace);
                        ExtendedPeakTracesUI.this.peakTracesUI.updateChart();
                        ExtendedPeakTracesUI.this.updateComboTraces();
                    }
                }
            }
        });
        return button;
    }

    private Button createButtonCopyTracesClipboard(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Copy the traces to clipboard.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/copy-clipboard.png", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<Integer> traces = ExtendedPeakTracesUI.this.peakTracesUI.getTraces();
                Iterator<Integer> iterator = traces.iterator();
                StringBuilder builder = new StringBuilder();
                while (iterator.hasNext()) {
                    builder.append(iterator.next());
                    if (!iterator.hasNext()) continue;
                    builder.append(" ");
                }
                TextTransfer textTransfer = TextTransfer.getInstance();
                Object[] data = new Object[]{builder.toString()};
                Transfer[] dataTypes = new Transfer[]{textTransfer};
                Clipboard clipboard = new Clipboard(e.widget.getDisplay());
                clipboard.setContents(data, dataTypes);
            }
        });
        return button;
    }

    private Button createActiveAnalysisButton(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setToolTipText("Toogle the active for analysis choice.");
        button.setText("");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExtendedPeakTracesUI.this.peak != null) {
                    boolean activeForAnalysis = button.getSelection();
                    ExtendedPeakTracesUI.this.peak.setActiveForAnalysis(activeForAnalysis);
                }
            }
        });
        return button;
    }

    private void createToggleChartSeriesLegendButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the chart series legend.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/tag.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedPeakTracesUI.this.peakTracesUI.toggleSeriesLegendVisibility();
            }
        });
    }

    private void createResetButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Reset the Overlay");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedPeakTracesUI.this.reset();
            }
        });
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)new PreferencePagePeakTraces()));
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("2", (IPreferencePage)new PreferencePageScans()));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedPeakTracesUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the chart settings.");
                    }
                }
            }
        });
    }

    private void createPeakChart(Composite parent) {
        this.peakTracesUI = new PeakTracesUI(parent, 2048);
        this.peakTracesUI.setLayoutData(new GridData(1808));
        IChartSettings chartSettings = this.peakTracesUI.getChartSettings();
        chartSettings.setCreateMenu(true);
        chartSettings.setShowLegendMarker(false);
        this.peakTracesUI.applySettings(chartSettings);
    }

    private void reset() {
        this.updatePeak();
    }

    private void applySettings() {
        this.updatePeak();
    }

    private void updateComboTraces() {
        this.comboViewerTraces.setInput(this.peakTracesUI.getTraces());
        this.buttonDeleteTrace.setEnabled(false);
    }
}

