/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractLabelProvider;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.support.ChromatogramEditorActionExtension;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.IChromatogramEditorAction;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ChromatogramActionUI
extends Composite {
    private static final Logger logger = Logger.getLogger(ChromatogramActionUI.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.ux.extension.xxd.ui.chromatogramEditorActionSupplier";
    private static final String EXTENSION_LABEL = "label";
    private static final String EXTENSION_DESCRIPTION = "description";
    private static final String EXTENSION_ACTION_EXECUTABLE = "actionExecutable";
    private static final String EXTENSION_MSD = "MSD";
    private static final String EXTENSION_CSD = "CSD";
    private static final String EXTENSION_WSD = "WSD";
    private ComboViewer comboChromatogramAction;
    private Button buttonChromatogramAction;
    private IChromatogramSelection chromatogramSelection;
    private String selectedActionId = "";
    private final HashMap<String, ChromatogramEditorActionExtension> actionHashMap = new HashMap();
    private final IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();

    public ChromatogramActionUI(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public void setChromatogramActionMenu(IChromatogramSelection chromatogramSelection) {
        this.chromatogramSelection = chromatogramSelection;
        boolean enabled = this.enableChromatogramActionMenu(chromatogramSelection);
        this.comboChromatogramAction.getCombo().setEnabled(enabled);
        if (enabled) {
            boolean success = this.setChromatogramActionItems((Control)this.comboChromatogramAction.getCombo(), chromatogramSelection);
            this.buttonChromatogramAction.setEnabled(success);
        } else {
            this.buttonChromatogramAction.setEnabled(false);
        }
    }

    private void initialize() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this.comboChromatogramAction = this.createChromatogramActionCombo(composite);
        this.buttonChromatogramAction = this.createChromatogramActionButton(composite);
    }

    private ComboViewer createChromatogramActionCombo(Composite parent) {
        final ComboViewer comboViewer = new ComboViewer(parent, 8);
        final Combo combo = comboViewer.getCombo();
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ChromatogramEditorActionExtension) {
                    return ((ChromatogramEditorActionExtension)element).getLabel();
                }
                return null;
            }
        });
        combo.setToolTipText("Select a chromatogram action.");
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        combo.setLayoutData((Object)gridData);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = comboViewer.getStructuredSelection().getFirstElement();
                if (object instanceof ChromatogramEditorActionExtension) {
                    ChromatogramEditorActionExtension extension = (ChromatogramEditorActionExtension)object;
                    combo.setToolTipText(extension.getDescription());
                    ChromatogramActionUI.this.buttonChromatogramAction.setEnabled(true);
                    String id = extension.getUniqueId();
                    ChromatogramActionUI.this.preferenceStore.putValue("chromatogramSelectedActionId", id);
                    ChromatogramActionUI.this.selectedActionId = id;
                }
            }
        });
        return comboViewer;
    }

    private Button createChromatogramActionButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Execute the selected chromatogram action.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/execute-extension.png", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ChromatogramActionUI.this.chromatogramSelection != null) {
                    ChromatogramEditorActionExtension extension = (ChromatogramEditorActionExtension)ChromatogramActionUI.this.actionHashMap.get(ChromatogramActionUI.this.selectedActionId);
                    if (extension != null) {
                        IChromatogramEditorAction action = extension.getChromatogramEditorAction();
                        if (action != null) {
                            IProcessingInfo processingInfo = action.applyAction(ChromatogramActionUI.this.chromatogramSelection);
                            ProcessingInfoViewSupport.updateProcessingInfo(processingInfo, (boolean)true);
                            e.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ChromatogramActionUI.this.chromatogramSelection.update(false);
                                }
                            });
                        }
                    } else {
                        MessageDialog.openInformation((Shell)DisplayUtils.getShell(), (String)"Action", (String)"Please select a execute method first via the button popup menu (right mouse click).");
                    }
                }
            }
        });
        return button;
    }

    private boolean setChromatogramActionItems(Control parent, IChromatogramSelection chromatogramSelection) {
        this.actionHashMap.clear();
        ArrayList<ChromatogramEditorActionExtension> activeExtensions = new ArrayList<ChromatogramEditorActionExtension>();
        for (ChromatogramEditorActionExtension extension : this.getChromatogramEditorExtensions()) {
            if (!this.isChromatogramSuitableForExtension(extension, chromatogramSelection)) continue;
            String id = extension.getUniqueId();
            this.actionHashMap.put(id, extension);
            activeExtensions.add(extension);
        }
        this.comboChromatogramAction.setInput(activeExtensions);
        boolean success = false;
        this.selectedActionId = this.preferenceStore.getString("chromatogramSelectedActionId");
        ChromatogramEditorActionExtension extension = this.actionHashMap.get(this.selectedActionId);
        if (extension != null) {
            Combo combo = this.comboChromatogramAction.getCombo();
            combo.setToolTipText(extension.getDescription());
            int index = this.getChromatogramActionSelectionIndex(activeExtensions, this.selectedActionId);
            if (index > -1) {
                combo.select(index);
                success = true;
            }
        }
        return success;
    }

    private boolean enableChromatogramActionMenu(IChromatogramSelection chromatogramSelection) {
        IConfigurationElement[] elements;
        boolean enabled = false;
        IConfigurationElement[] iConfigurationElementArray = elements = this.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            ChromatogramEditorActionExtension extension = new ChromatogramEditorActionExtension();
            extension.setMSD(Boolean.valueOf(element.getAttribute(EXTENSION_MSD)));
            extension.setCSD(Boolean.valueOf(element.getAttribute(EXTENSION_CSD)));
            extension.setWSD(Boolean.valueOf(element.getAttribute(EXTENSION_WSD)));
            if (this.isChromatogramSuitableForExtension(extension, chromatogramSelection)) {
                enabled = true;
                break;
            }
            ++n2;
        }
        return enabled;
    }

    private List<ChromatogramEditorActionExtension> getChromatogramEditorExtensions() {
        IConfigurationElement[] elements;
        ArrayList<ChromatogramEditorActionExtension> extensions = new ArrayList<ChromatogramEditorActionExtension>();
        IConfigurationElement[] iConfigurationElementArray = elements = this.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                ChromatogramEditorActionExtension extension = new ChromatogramEditorActionExtension();
                extension.setLabel(element.getAttribute(EXTENSION_LABEL));
                extension.setDescription(element.getAttribute(EXTENSION_DESCRIPTION));
                extension.setChromatogramEditorAction((IChromatogramEditorAction)element.createExecutableExtension(EXTENSION_ACTION_EXECUTABLE));
                extension.setMSD(Boolean.valueOf(element.getAttribute(EXTENSION_MSD)));
                extension.setCSD(Boolean.valueOf(element.getAttribute(EXTENSION_CSD)));
                extension.setWSD(Boolean.valueOf(element.getAttribute(EXTENSION_WSD)));
                extensions.add(extension);
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
            ++n2;
        }
        return extensions;
    }

    private boolean isChromatogramSuitableForExtension(ChromatogramEditorActionExtension extension, IChromatogramSelection<? extends IPeak, ?> chromatogramSelection) {
        if (extension != null && chromatogramSelection != null) {
            if (chromatogramSelection instanceof IChromatogramSelectionMSD && extension.isMSD()) {
                return true;
            }
            if (chromatogramSelection instanceof IChromatogramSelectionCSD && extension.isCSD()) {
                return true;
            }
            if (chromatogramSelection instanceof IChromatogramSelectionWSD && extension.isWSD()) {
                return true;
            }
        }
        return false;
    }

    private IConfigurationElement[] getConfigurationElements() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        return elements;
    }

    private int getChromatogramActionSelectionIndex(List<ChromatogramEditorActionExtension> extensions, String actionId) {
        int index = -1;
        int i = 0;
        while (i < extensions.size()) {
            ChromatogramEditorActionExtension extension = extensions.get(i);
            String id = extension.getUniqueId();
            if (id.equals(actionId)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }
}

