/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.equations.Equations;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;
import org.eclipse.chemclipse.numeric.exceptions.SolverException;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.SeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;
import org.eclipse.swtchart.extensions.linecharts.LineSeriesData;

public class PeakChartSupport {
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.0");

    public ILineSeriesData getPeaks(Collection<? extends IPeak> peaks, boolean includeBackground, boolean mirrored, Color color, String id) {
        ISeriesData seriesData = this.getPeakSeriesData(peaks, includeBackground, mirrored, id);
        return this.getLineSeriesData(seriesData, color, true);
    }

    public ILineSeriesData getPeak(IPeak peak, boolean includeBackground, boolean mirrored, Color color, String id) {
        ISeriesData seriesData = this.getPeakSeriesData(peak, includeBackground, mirrored, id);
        return this.getLineSeriesData(seriesData, color, true);
    }

    public ILineSeriesData getIncreasingTangent(IPeak peak, boolean includeBackground, boolean mirrored, Color color, String postfix) {
        ISeriesData seriesData = this.getIncreasingInflectionData(peak, includeBackground, mirrored, postfix);
        return this.getLineSeriesData(seriesData, color, false);
    }

    public ILineSeriesData getDecreasingTangent(IPeak peak, boolean includeBackground, boolean mirrored, Color color, String postfix) {
        ISeriesData seriesData = this.getDecreasingInflectionData(peak, includeBackground, mirrored, postfix);
        return this.getLineSeriesData(seriesData, color, false);
    }

    public ILineSeriesData getPeakPerpendicular(IPeak peak, boolean includeBackground, boolean mirrored, Color color, String postfix) {
        ISeriesData seriesData = this.getPeakPerpendicularData(peak, includeBackground, mirrored, postfix);
        return this.getLineSeriesData(seriesData, color, false);
    }

    public ILineSeriesData getPeakWidth(IPeak peak, boolean includeBackground, float height, boolean mirrored, Color color, String postfix) {
        ISeriesData seriesData = this.getPeakWidthByInflectionData(peak, includeBackground, height, mirrored, postfix);
        return this.getLineSeriesData(seriesData, color, false);
    }

    public ILineSeriesData getPeakBaseline(IPeak peak, boolean mirrored, Color color, String id) {
        ISeriesData seriesData = this.getPeakBaselineData(peak, mirrored, id);
        return this.getLineSeriesData(seriesData, color, false);
    }

    public ILineSeriesData getPeakBackground(IPeak peak, boolean mirrored, Color color, String id) {
        ISeriesData seriesData = this.getPeakBaselineData(peak, mirrored, id);
        return this.getLineSeriesData(seriesData, color, true);
    }

    private ILineSeriesData getLineSeriesData(ISeriesData seriesData, Color color, boolean enableArea) {
        LineSeriesData lineSeriesData = new LineSeriesData(seriesData);
        ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
        lineSeriesSettings.setLineColor(color);
        lineSeriesSettings.setEnableArea(enableArea);
        ILineSeriesSettings lineSeriesSettingsHighlight = (ILineSeriesSettings)lineSeriesSettings.getSeriesSettingsHighlight();
        lineSeriesSettingsHighlight.setLineWidth(2);
        return lineSeriesData;
    }

    public ISeriesData getPeakSeriesData(Collection<? extends IPeak> peaks, boolean includeBackground, boolean mirrored, String id) {
        int size = peaks.size();
        double[] xSeries = new double[size];
        double[] ySeries = new double[size];
        int index = 0;
        for (IPeak iPeak : peaks) {
            IPeakModel peakModel = iPeak.getPeakModel();
            int retentionTime = peakModel.getRetentionTimeAtPeakMaximum();
            xSeries[index] = retentionTime;
            ySeries[index] = includeBackground ? (double)(peakModel.getBackgroundAbundance(retentionTime) + peakModel.getPeakAbundance(retentionTime)) : (double)peakModel.getPeakAbundance(retentionTime);
            if (mirrored) {
                ySeries[index] = ySeries[index] * -1.0;
            }
            ++index;
        }
        return new SeriesData(xSeries, ySeries, id);
    }

    private ISeriesData getPeakSeriesData(IPeak peak, boolean includeBackground, boolean mirrored, String id) {
        IPeakModel peakModel = peak.getPeakModel();
        List retentionTimes = peakModel.getRetentionTimes();
        int size = retentionTimes.size();
        double[] xSeries = new double[size];
        double[] ySeries = new double[size];
        int index = 0;
        Iterator iterator = retentionTimes.iterator();
        while (iterator.hasNext()) {
            int retentionTime = (Integer)iterator.next();
            xSeries[index] = retentionTime;
            ySeries[index] = includeBackground ? (double)(peakModel.getBackgroundAbundance(retentionTime) + peakModel.getPeakAbundance(retentionTime)) : (double)peakModel.getPeakAbundance(retentionTime);
            if (mirrored) {
                ySeries[index] = ySeries[index] * -1.0;
            }
            ++index;
        }
        return new SeriesData(xSeries, ySeries, id);
    }

    private ISeriesData getIncreasingInflectionData(IPeak peak, boolean includeBackground, boolean mirrored, String postfix) {
        String id = "Increasing Tangent" + postfix;
        double[] xSeries = new double[2];
        double[] ySeries = new double[2];
        if (peak != null) {
            IPeakModel peakModel = peak.getPeakModel();
            try {
                double x;
                LinearEquation increasing = peakModel.getIncreasingInflectionPointEquation();
                LinearEquation decreasing = peakModel.getDecreasingInflectionPointEquation();
                LinearEquation baseline = peakModel.getPercentageHeightBaselineEquation(0.0f);
                IPoint intersection = Equations.calculateIntersection((LinearEquation)increasing, (LinearEquation)baseline);
                double startRetentionTime = peakModel.getStartRetentionTime();
                xSeries[0] = x = intersection.getX() < startRetentionTime ? startRetentionTime : intersection.getX();
                ySeries[0] = includeBackground ? intersection.getY() + (double)peakModel.getBackgroundAbundance((int)x) : intersection.getY();
                if (mirrored) {
                    ySeries[0] = ySeries[0] * -1.0;
                }
                intersection = Equations.calculateIntersection((LinearEquation)increasing, (LinearEquation)decreasing);
                double stopRetentionTime = peakModel.getStopRetentionTime();
                x = intersection.getX() > stopRetentionTime ? stopRetentionTime : intersection.getX();
                xSeries[1] = intersection.getX();
                ySeries[1] = includeBackground ? intersection.getY() + (double)peakModel.getBackgroundAbundance((int)x) : intersection.getY();
                if (mirrored) {
                    ySeries[1] = ySeries[1] * -1.0;
                }
            }
            catch (SolverException solverException) {
                // empty catch block
            }
        }
        return new SeriesData(xSeries, ySeries, id);
    }

    private ISeriesData getDecreasingInflectionData(IPeak peak, boolean includeBackground, boolean mirrored, String postfix) {
        String id = "Decreasing Tangent" + postfix;
        double[] xSeries = new double[2];
        double[] ySeries = new double[2];
        if (peak != null) {
            IPeakModel peakModel = peak.getPeakModel();
            try {
                LinearEquation increasing = peakModel.getIncreasingInflectionPointEquation();
                LinearEquation decreasing = peakModel.getDecreasingInflectionPointEquation();
                LinearEquation baseline = peakModel.getPercentageHeightBaselineEquation(0.0f);
                IPoint intersection = Equations.calculateIntersection((LinearEquation)decreasing, (LinearEquation)baseline);
                double stopRetentionTime = peakModel.getStopRetentionTime();
                double x = intersection.getX() > stopRetentionTime ? stopRetentionTime : intersection.getX();
                xSeries[0] = intersection.getX();
                ySeries[0] = includeBackground ? intersection.getY() + (double)peakModel.getBackgroundAbundance((int)x) : intersection.getY();
                if (mirrored) {
                    ySeries[0] = ySeries[0] * -1.0;
                }
                intersection = Equations.calculateIntersection((LinearEquation)increasing, (LinearEquation)decreasing);
                double startRetentionTime = peakModel.getStartRetentionTime();
                x = intersection.getX() < startRetentionTime ? startRetentionTime : intersection.getX();
                xSeries[1] = intersection.getX();
                ySeries[1] = includeBackground ? intersection.getY() + (double)peakModel.getBackgroundAbundance((int)x) : intersection.getY();
                if (mirrored) {
                    ySeries[1] = ySeries[1] * -1.0;
                }
            }
            catch (SolverException solverException) {
                // empty catch block
            }
        }
        return new SeriesData(xSeries, ySeries, id);
    }

    private ISeriesData getPeakPerpendicularData(IPeak peak, boolean includeBackground, boolean mirrored, String postfix) {
        String id = "Peak Perpendicular" + postfix;
        double[] xSeries = new double[2];
        double[] ySeries = new double[2];
        if (peak != null) {
            IPeakModel peakModel = peak.getPeakModel();
            xSeries[0] = peakModel.getRetentionTimeAtPeakMaximumByInflectionPoints();
            ySeries[0] = includeBackground ? (double)peakModel.getBackgroundAbundance(peakModel.getRetentionTimeAtPeakMaximumByInflectionPoints()) : 0.0;
            if (mirrored) {
                ySeries[0] = ySeries[0] * -1.0;
            }
            try {
                IPoint intersection = Equations.calculateIntersection((LinearEquation)peakModel.getIncreasingInflectionPointEquation(), (LinearEquation)peakModel.getDecreasingInflectionPointEquation());
                xSeries[1] = intersection.getX();
                ySeries[1] = includeBackground ? intersection.getY() + (double)peakModel.getBackgroundAbundance((int)intersection.getX()) : intersection.getY();
                if (mirrored) {
                    ySeries[1] = ySeries[1] * -1.0;
                }
            }
            catch (SolverException solverException) {
                // empty catch block
            }
        }
        return new SeriesData(xSeries, ySeries, id);
    }

    private ISeriesData getPeakWidthByInflectionData(IPeak peak, boolean includeBackground, float height, boolean mirrored, String postfix) {
        String id = "Peak Width" + postfix;
        double[] xSeries = new double[2];
        double[] ySeries = new double[2];
        if (peak != null) {
            IPeakModel peakModel = peak.getPeakModel();
            LinearEquation percentageHeightBaseline = peakModel.getPercentageHeightBaselineEquation(height);
            if (percentageHeightBaseline != null) {
                try {
                    IPoint p1 = Equations.calculateIntersection((LinearEquation)peakModel.getIncreasingInflectionPointEquation(), (LinearEquation)percentageHeightBaseline);
                    IPoint p2 = Equations.calculateIntersection((LinearEquation)peakModel.getDecreasingInflectionPointEquation(), (LinearEquation)percentageHeightBaseline);
                    double startRetentionTime = peakModel.getStartRetentionTime();
                    double x = p1.getX() < startRetentionTime ? startRetentionTime : p1.getX();
                    xSeries[0] = p1.getX();
                    ySeries[0] = includeBackground ? p1.getY() + (double)peakModel.getBackgroundAbundance((int)x) : p1.getY();
                    if (mirrored) {
                        ySeries[0] = ySeries[0] * -1.0;
                    }
                    double stopRetentionTime = peakModel.getStopRetentionTime();
                    x = p2.getX() > stopRetentionTime ? stopRetentionTime : p2.getX();
                    xSeries[1] = p2.getX();
                    ySeries[1] = includeBackground ? p2.getY() + (double)peakModel.getBackgroundAbundance((int)x) : p2.getY();
                    if (mirrored) {
                        ySeries[1] = ySeries[1] * -1.0;
                    }
                }
                catch (SolverException solverException) {
                    // empty catch block
                }
            }
            id = "Peak" + postfix + " Width at " + this.decimalFormat.format(height * 100.0f) + "%";
        }
        return new SeriesData(xSeries, ySeries, id);
    }

    private ISeriesData getPeakBaselineData(IPeak peak, boolean mirrored, String id) {
        IPeakModel peakModel = peak.getPeakModel();
        List retentionTimes = peakModel.getRetentionTimes();
        int size = retentionTimes.size();
        double[] xSeries = new double[size];
        double[] ySeries = new double[size];
        int index = 0;
        Iterator iterator = peakModel.getRetentionTimes().iterator();
        while (iterator.hasNext()) {
            int retentionTime = (Integer)iterator.next();
            xSeries[index] = retentionTime;
            ySeries[index] = peakModel.getBackgroundAbundance(retentionTime);
            if (mirrored) {
                ySeries[index] = ySeries[index] * -1.0;
            }
            ++index;
        }
        return new SeriesData(xSeries, ySeries, id);
    }
}

