/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.support;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.chemclipse.model.core.Classifiable;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.ITargetSupplier;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.TargetDisplaySettings;
import org.eclipse.core.runtime.Adapters;

public interface TargetReference
extends ITargetSupplier {
    public String getName();

    public String getID();

    public String getType();

    default public IIdentificationTarget getBestTarget() {
        return IIdentificationTarget.getBestIdentificationTarget((Set)this.getTargets());
    }

    default public String getTargetLabel(TargetDisplaySettings.LibraryField libraryField) {
        IPeak peak;
        if (libraryField == TargetDisplaySettings.LibraryField.NAME && (peak = (IPeak)Adapters.adapt((Object)this, IPeak.class)) != null) {
            String name = peak.getName();
            if (name != null) {
                return name;
            }
            return name;
        }
        if (libraryField == TargetDisplaySettings.LibraryField.CLASSIFICATION && (peak = (IPeak)Adapters.adapt((Object)this, IPeak.class)) != null) {
            ILibraryInformation libraryInformation;
            LinkedHashSet set = new LinkedHashSet();
            Collection classifier = peak.getClassifier();
            set.addAll(classifier);
            IIdentificationTarget bestTarget = this.getBestTarget();
            if (bestTarget != null && (libraryInformation = bestTarget.getLibraryInformation()) != null) {
                set.addAll(libraryInformation.getClassifier());
            }
            return Classifiable.asString(set);
        }
        IIdentificationTarget bestTarget = this.getBestTarget();
        if (bestTarget != null) {
            return libraryField.stringTransformer().apply(bestTarget);
        }
        return null;
    }
}

