/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.parts;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.EnhancedUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.IUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ExtendedScanChartUI;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.widgets.Composite;

public class ScanChartPart
extends EnhancedUpdateSupport
implements IUpdateSupport {
    private ExtendedScanChartUI extendedScanChartUI;

    @Inject
    public ScanChartPart(Composite parent, MPart part) {
        super(parent, Activator.getDefault().getDataUpdateSupport(), "scan/xxd/update/selection", part);
    }

    @Override
    public void createControl(Composite parent) {
        this.extendedScanChartUI = new ExtendedScanChartUI(parent, Activator.getDefault().getEventBroker());
    }

    @Override
    public void updateSelection(List<Object> objects, String topic) {
        if (objects.size() == 1 && this.isScanOrPeakTopic(topic)) {
            Object object = objects.get(0);
            IScan scan = null;
            if (object instanceof IScan) {
                scan = (IScan)object;
            } else if (object instanceof IPeak) {
                IPeak peak = (IPeak)object;
                scan = peak.getPeakModel().getPeakMaximum();
            }
            this.extendedScanChartUI.update(scan);
        }
    }

    private boolean isScanOrPeakTopic(String topic) {
        if (topic.equals("scan/xxd/update/selection")) {
            return true;
        }
        return topic.equals("peak/xxd/update/selection");
    }
}

