/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.parts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IMeasurementResult;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.AbstractDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.IDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.MeasurementResultNotification;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChromatogramDataSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ExtendedMeasurementResultUI;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;

public class MeasurementResultsPart
extends AbstractDataUpdateSupport
implements IDataUpdateSupport {
    private final ExtendedMeasurementResultUI extendedMeasurementResultUI;
    @Inject
    private MeasurementResultNotification notification;

    @Inject
    public MeasurementResultsPart(Composite parent, MPart part) {
        super(part);
        this.extendedMeasurementResultUI = new ExtendedMeasurementResultUI(parent);
        ComboViewer comboViewer = this.extendedMeasurementResultUI.getComboMeasurementResults();
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object element;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IMeasurementResult) {
                    MeasurementResultsPart.this.notification.select((IMeasurementResult)element);
                    return;
                }
                MeasurementResultsPart.this.notification.select(null);
            }
        });
    }

    @Focus
    public void setFocus() {
        this.updateObjects(this.getObjects(), this.getTopic());
    }

    @Override
    public void registerEvents() {
        this.registerEvent("chromatogram/xxd/load/chromatogramselection", "org.eclipse.e4.data");
        this.registerEvent("chromatogram/xxd/unload/chromatogramselection", "org.eclipse.e4.data");
    }

    @Override
    public void updateObjects(List<Object> objects, String topic) {
        Object object;
        List<IMeasurementResult<?>> results = Collections.emptyList();
        String infoLabel = "";
        if (!this.isUnloadEvent(topic) && objects.size() == 1 && (object = objects.get(0)) instanceof IChromatogramSelection) {
            IChromatogramSelection selection = (IChromatogramSelection)object;
            IChromatogram chromatogram = selection.getChromatogram();
            results = new ArrayList(chromatogram.getMeasurementResults());
            infoLabel = ChromatogramDataSupport.getChromatogramLabel(chromatogram);
        }
        this.notification.select(null);
        this.extendedMeasurementResultUI.update(results, infoLabel);
    }

    private boolean isUnloadEvent(String topic) {
        return topic.equals("chromatogram/xxd/unload/chromatogramselection");
    }
}

