/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.parts;

import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.AbstractDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.IDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ExtendedComparisonScanUI;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.widgets.Composite;

public class ComparisonScanChartPart
extends AbstractDataUpdateSupport
implements IDataUpdateSupport {
    private final ExtendedComparisonScanUI extendedComparisonScanUI;
    private static final int TARGET_MASS_SPECTRUM_UNKNOWN = 0;
    private static final int TARGET_ENTRY = 1;

    @Inject
    public ComparisonScanChartPart(Composite parent, MPart part) {
        super(part);
        this.extendedComparisonScanUI = new ExtendedComparisonScanUI(parent, 2048);
    }

    @Focus
    public void setFocus() {
    }

    @Override
    public void registerEvents() {
        this.registerEvent("scan/xxd/update/selection", "org.eclipse.e4.data");
        this.registerEvent("scan/xxd/unload/selection", "org.eclipse.e4.data");
        this.registerEvent("peak/xxd/update/selection", "org.eclipse.e4.data");
        this.registerEvent("peak/xxd/unload/selection", "org.eclipse.e4.data");
        String[] properties = new String[]{"MassSpectrumUnknown", "IdentificationTarget"};
        this.registerEvent("identification/target/update/massspectrum/unknown", properties);
    }

    @Override
    public void updateObjects(List<Object> objects, String topic) {
        if (this.isUnloadEvent(topic)) {
            this.extendedComparisonScanUI.update(null);
            return;
        }
        if ("identification/target/update/massspectrum/unknown".equals(topic)) {
            IScanMSD unknownMassSpectrum = (IScanMSD)objects.get(0);
            IIdentificationTarget identificationTarget = (IIdentificationTarget)objects.get(1);
            this.extendedComparisonScanUI.update(unknownMassSpectrum, identificationTarget);
        } else if ("peak/xxd/update/selection".equals(topic) || "scan/xxd/update/selection".equals(topic)) {
            IScanMSD scan;
            Object object = objects.get(0);
            IIdentificationTarget target = null;
            if (object instanceof IScanMSD) {
                scan = (IScanMSD)object;
                target = IIdentificationTarget.getBestIdentificationTarget((Set)scan.getTargets());
            } else if (object instanceof IPeakMSD) {
                IPeakMSD peakMSD = (IPeakMSD)object;
                scan = peakMSD.getExtractedMassSpectrum();
                target = IIdentificationTarget.getBestIdentificationTarget((Set)peakMSD.getTargets());
            } else {
                return;
            }
            if (target != null) {
                this.extendedComparisonScanUI.update(scan, target);
            } else {
                this.extendedComparisonScanUI.update(scan);
            }
        }
    }

    private boolean isUnloadEvent(String topic) {
        if (topic.equals("scan/xxd/unload/selection")) {
            return true;
        }
        return topic.equals("peak/xxd/unload/selection");
    }
}

