/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.methods;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessorPreferences;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.ux.extension.xxd.ui.methods.SettingsWizard;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class SettingsPreferencesEditPage
extends WizardPage {
    private TreeViewer treeViewer;
    private final Supplier<Collection<ProcessorPreferences<?>>> preferenceSupplier;

    public SettingsPreferencesEditPage(Supplier<Collection<ProcessorPreferences<?>>> preferenceSupplier) {
        super(SettingsPreferencesEditPage.class.getName());
        this.preferenceSupplier = preferenceSupplier;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.treeViewer = new TreeViewer(composite);
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        TreeViewerColumn column = new TreeViewerColumn(this.treeViewer, 0);
        column.getColumn().setWidth(300);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ProcessorPreferences entry;
                if (element instanceof TreeNode) {
                    element = ((TreeNode)element).getValue();
                }
                if ((entry = SettingsPreferencesEditPage.getEntry(element)) != null) {
                    return entry.getSupplier().getName();
                }
                return super.getText(element);
            }
        });
        column = new TreeViewerColumn(this.treeViewer, 0x1000000);
        column.getColumn().setWidth(110);
        column.getColumn().setText("ask for settings");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ProcessorPreferences preferences = SettingsPreferencesEditPage.getEntry(element);
                if (preferences != null) {
                    if (preferences.getDialogBehaviour() == ProcessorPreferences.DialogBehavior.SHOW) {
                        return "yes";
                    }
                    return "no";
                }
                return "";
            }
        });
        column = new TreeViewerColumn(this.treeViewer, 0);
        column.getColumn().setWidth(500);
        column.getColumn().setText("Options");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ProcessorPreferences preferences;
                if (element instanceof TreeNode) {
                    element = ((TreeNode)element).getValue();
                }
                if ((preferences = SettingsPreferencesEditPage.getEntry(element)) != null) {
                    if (preferences.isUseSystemDefaults()) {
                        return "(System Default)";
                    }
                    return preferences.getUserSettingsAsString();
                }
                return "";
            }
        });
        ToolBar toolBar = new ToolBar(composite, 0x800200);
        toolBar.setLayoutData((Object)new GridData(0x1000000, 128, false, true));
        final ToolItem edit = new ToolItem(toolBar, 8);
        edit.setToolTipText("Edit stored data for this processor");
        edit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    SettingsPreferencesEditPage.this.doEdit();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        edit.setEnabled(false);
        edit.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/edit.gif", "16x16"));
        final ToolItem delete = new ToolItem(toolBar, 8);
        delete.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object[] array;
                Object[] objectArray = array = SettingsPreferencesEditPage.this.treeViewer.getStructuredSelection().toArray();
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    SettingsPreferencesEditPage.getEntry(object).reset();
                    ++n2;
                }
                SettingsPreferencesEditPage.this.updateTree();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        delete.setEnabled(false);
        delete.setToolTipText("Removes the stored data for this processor and reset it to the defaults");
        delete.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/delete.gif", "16x16"));
        ToolItem delete_all = new ToolItem(toolBar, 8);
        delete_all.setToolTipText("Removes all stored data for this processor and reset it to the defaults");
        delete_all.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/delete_all.png", "16x16"));
        delete_all.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                for (ProcessorPreferences preferences : (Collection)SettingsPreferencesEditPage.this.preferenceSupplier.get()) {
                    preferences.reset();
                }
                SettingsPreferencesEditPage.this.updateTree();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITreeSelection selection = SettingsPreferencesEditPage.this.treeViewer.getStructuredSelection();
                Object[] array = selection.toArray();
                boolean buttonsEnabled = array.length > 0;
                Object[] objectArray = array;
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (SettingsPreferencesEditPage.getEntry(object) == null) {
                        buttonsEnabled = false;
                        break;
                    }
                    ++n2;
                }
                edit.setEnabled(buttonsEnabled && array.length == 1);
                delete.setEnabled(buttonsEnabled);
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                try {
                    SettingsPreferencesEditPage.this.doEdit();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.updateTree();
        this.setControl((Control)composite);
    }

    private void doEdit() throws IOException {
        ITreeSelection selection = this.treeViewer.getStructuredSelection();
        ProcessorPreferences entry = SettingsPreferencesEditPage.getEntry(selection.getFirstElement());
        if (entry != null && SettingsWizard.openEditPreferencesWizard(this.getShell(), entry)) {
            this.updateTree();
        }
    }

    private void updateTree() {
        TreeMap<String, TreeNode> categories = new TreeMap<String, TreeNode>();
        for (ProcessorPreferences<?> entry : this.preferenceSupplier.get()) {
            IProcessTypeSupplier supplier = entry.getSupplier().getTypeSupplier();
            TreeNode processorNode = new TreeNode(entry);
            String category = supplier.getCategory();
            TreeNode categoryNode = (TreeNode)categories.get(category);
            if (categoryNode == null) {
                categoryNode = new TreeNode((Object)category);
                categoryNode.setChildren(new TreeNode[]{processorNode});
                categories.put(category, categoryNode);
            } else {
                TreeNode[] children = categoryNode.getChildren();
                TreeNode[] copyOf = Arrays.copyOf(children, children.length + 1);
                copyOf[children.length] = processorNode;
                categoryNode.setChildren(copyOf);
            }
            processorNode.setParent(categoryNode);
        }
        this.treeViewer.setInput((Object)categories.values().toArray(new TreeNode[0]));
        this.treeViewer.refresh();
        this.treeViewer.expandAll();
    }

    private static <T> ProcessorPreferences<T> getEntry(Object element) {
        if (element instanceof TreeNode) {
            element = ((TreeNode)element).getValue();
        }
        if (element instanceof ProcessorPreferences) {
            return (ProcessorPreferences)element;
        }
        return null;
    }
}

