/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class RetentionIndexValidator
implements IValidator {
    private static final String ERROR = "Please enter a correct retention index, e.g. 600";
    private static final String ERROR_VALUE_RANGE = "The retention index must be not <= 0.";
    private float retentionIndex = 0.0f;

    public IStatus validate(Object value) {
        String message;
        block8: {
            message = null;
            this.retentionIndex = 0.0f;
            if (value == null) {
                message = ERROR;
            } else if (value instanceof String) {
                try {
                    float retentionIndex = Float.parseFloat(((String)value).trim());
                    if ((double)retentionIndex <= 0.0) {
                        message = ERROR_VALUE_RANGE;
                        break block8;
                    }
                    this.retentionIndex = retentionIndex;
                }
                catch (NumberFormatException e) {
                    message = ERROR;
                }
            } else {
                message = ERROR;
            }
        }
        if (message != null) {
            return ValidationStatus.error((String)message);
        }
        return ValidationStatus.ok();
    }

    public float getRetentionIndex() {
        return this.retentionIndex;
    }
}

