/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class ConcentrationValidator
implements IValidator {
    private static final String ERROR = "Please enter a correct concentration, e.g. 10 mg/L.";
    private static final String ERROR_VALUE_RANGE = "The concentration must be not <= 0.";
    private double concentration = 0.0;
    private String unit = "";

    public IStatus validate(Object value) {
        String message;
        block10: {
            message = null;
            this.concentration = 0.0;
            this.unit = "";
            if (value == null) {
                message = ERROR;
            } else if (value instanceof String) {
                String text = ((String)value).trim();
                String[] values = text.split(" ");
                if (values.length != 2) {
                    message = ERROR;
                } else {
                    try {
                        double concentration = Double.parseDouble(values[0]);
                        if (concentration <= 0.0) {
                            message = ERROR_VALUE_RANGE;
                            break block10;
                        }
                        this.concentration = concentration;
                        this.unit = values[1];
                    }
                    catch (NumberFormatException e) {
                        message = ERROR;
                    }
                }
            } else {
                message = ERROR;
            }
        }
        if (message != null) {
            return ValidationStatus.error((String)message);
        }
        return ValidationStatus.ok();
    }

    public double getConcentration() {
        return this.concentration;
    }

    public String getUnit() {
        return this.unit;
    }
}

