/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import org.eclipse.chemclipse.model.quantitation.IResponseSignal;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class QuantResponseEditingSupport
extends EditingSupport {
    private CellEditor cellEditor;
    private ExtendedTableViewer tableViewer;
    private String column;

    public QuantResponseEditingSupport(ExtendedTableViewer tableViewer, String column) {
        super((ColumnViewer)tableViewer);
        this.column = column;
        this.cellEditor = new TextCellEditor((Composite)tableViewer.getTable());
        this.tableViewer = tableViewer;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    protected boolean canEdit(Object element) {
        return this.tableViewer.isEditEnabled();
    }

    protected Object getValue(Object element) {
        block7: {
            if (!(element instanceof IResponseSignal)) break block7;
            IResponseSignal signal = (IResponseSignal)element;
            switch (this.column) {
                case "Response": {
                    return Double.toString(signal.getResponse());
                }
            }
        }
        return false;
    }

    protected void setValue(Object element, Object value) {
        block7: {
            if (!(element instanceof IResponseSignal)) break block7;
            IResponseSignal signal = (IResponseSignal)element;
            switch (this.column) {
                case "Response": {
                    double response = this.getValue(value, -1.0);
                    if (!(response >= 0.0)) break;
                    signal.setResponse(response);
                }
            }
            this.tableViewer.refresh();
        }
    }

    private double getValue(Object value, double def) {
        double result = def;
        if (value instanceof String) {
            try {
                result = Double.parseDouble((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }
}

