/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.editors;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.converter.exceptions.NoChromatogramConverterAvailableException;
import org.eclipse.chemclipse.converter.model.reports.ISequence;
import org.eclipse.chemclipse.converter.model.reports.ISequenceRecord;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.chemclipse.processing.ui.E4ProcessSupplierContext;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.runnables.SequenceImportRunnable;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.AbstractDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.IDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors.ExtendedSequenceListUI;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class SequenceEditor
extends AbstractDataUpdateSupport
implements IDataUpdateSupport {
    private static final Logger logger = Logger.getLogger(SequenceEditor.class);
    public static final String ID = "org.eclipse.chemclipse.ux.extension.xxd.ui.part.sequenceEditor";
    public static final String CONTRIBUTION_URI = "bundleclass://org.eclipse.chemclipse.ux.extension.xxd.ui/org.eclipse.chemclipse.ux.extension.xxd.ui.editors.SequenceEditor";
    public static final String ICON_URI = "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/sequenceListDefault.gif";
    public static final String TOOLTIP = "Sequence Editor";
    private final MPart part;
    private final MDirtyable dirtyable;
    private File sequenceFile;
    private ExtendedSequenceListUI extendedSequenceListUI;
    @Inject
    private E4ProcessSupplierContext processContext;

    @Inject
    public SequenceEditor(Composite parent, MPart part, MDirtyable dirtyable, Shell shell) {
        super(part);
        this.part = part;
        this.dirtyable = dirtyable;
        this.initialize(parent);
    }

    @Override
    public void registerEvents() {
    }

    @Override
    public void updateObjects(List<Object> objects, String topic) {
        objects.size();
    }

    @Focus
    public void setFocus() {
    }

    @Override
    @PreDestroy
    protected void preDestroy() {
        super.preDestroy();
        EModelService modelService = ModelSupportAddon.getModelService();
        if (modelService != null) {
            MApplication application = ModelSupportAddon.getApplication();
            final MPartStack partStack = (MPartStack)modelService.find("org.eclipse.e4.primaryDataStack", (MUIElement)application);
            this.part.setToBeRendered(false);
            this.part.setVisible(false);
            DisplayUtils.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    partStack.getChildren().remove(SequenceEditor.this.part);
                }
            });
        }
        System.gc();
    }

    @Persist
    public void save() {
        System.out.println(this.sequenceFile);
        this.dirtyable.setDirty(false);
    }

    private void initialize(Composite parent) {
        this.createEditorPages(parent);
        this.extendedSequenceListUI.update(this.loadSequence());
    }

    private synchronized ISequence<? extends ISequenceRecord> loadSequence() {
        ISequence<? extends ISequenceRecord> sequence = null;
        try {
            Object object = this.part.getObject();
            if (object instanceof Map) {
                Map map = (Map)object;
                File file = new File((String)map.get("File"));
                boolean batch = (Boolean)map.get("Batch");
                sequence = this.loadSequence(file, batch);
            } else {
                if (object instanceof ISequence) {
                    sequence = (ISequence<? extends ISequenceRecord>)object;
                }
                this.sequenceFile = null;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return sequence;
    }

    private synchronized ISequence<? extends ISequenceRecord> loadSequence(File file, boolean batch) throws FileNotFoundException, NoChromatogramConverterAvailableException, FileIsNotReadableException, FileIsEmptyException, ChromatogramIsNullException {
        ISequence<? extends ISequenceRecord> sequence = null;
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(DisplayUtils.getShell());
        SequenceImportRunnable runnable = new SequenceImportRunnable(file);
        try {
            boolean fork = !batch;
            dialog.run(fork, false, (IRunnableWithProgress)runnable);
            sequence = runnable.getSequence();
            this.sequenceFile = file;
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e);
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
        return sequence;
    }

    private void createEditorPages(Composite parent) {
        this.createPage(parent);
    }

    private void createPage(Composite parent) {
        this.extendedSequenceListUI = new ExtendedSequenceListUI(parent, (ProcessSupplierContext)this.processContext);
    }
}

